import AbstractPrintOptState from "./AbstractPrintOptState";
import SectionView from "../view/element/SectionView";
import {CellView} from "../view/element/CellView";
import BaseConstants from "../../base/BaseConstants";
import ITagNode from "../../../common/xml/node/ITagNode";
import PrintNodeUtil from "../util/PrintNodeUtil";

export default class SelectAreaState extends AbstractPrintOptState {

    private startX = 0;

    private startY = 0;
    private el: any;

    private startRowindex: number = 0;
    private startColindex: number = 0;
    private sectionView: SectionView | undefined;

    private selects: Array<any> | undefined;

    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
        this.startX = x;
        this.startY = y;
    }

    mousemove(e: MouseEvent): void {
        if (!(e.button == 0 && e.buttons == 1)) {
            var selectionModel = this.getView().getXmlEntity().getSelectionModel();
            selectionModel.setBMultiSelection(false);
            this.getDelegate().setNormalState();
            return;
        }
        this.startRowindex = Number(this.el.getAttribute("rowindex"));
        this.startColindex = Number(this.el.getAttribute("colindex"));
        this.sectionView = this.getView().getSectionView(this.startX, this.startY);
        var {x, y} = this.getPosition(e);
        if (this.startX == x && this.startY == y) {
            return;
        }
        var sectionView = this.getView().getSectionView(x, y);
        if (sectionView !== this.sectionView) {
            return;
        }
        var cellView: CellView | null = this.getView().hitMultiTagNode(x, y);
        if (cellView == null) {
            return;
        }
        var rowindex = cellView.getRowIndex();
        var colindex = cellView.getColIndex();
        var selectionModel = this.getView().getXmlEntity().getSelectionModel();
        selectionModel.setBMultiSelection(true);
        var xX = this.startColindex;//0
        var yY = this.startRowindex;//1
        this.getView().getXmlEntity().getSelectionModel().reset();
        var isMergeHandle = false;
        var array = new Array<any>();
        if (colindex >= xX && rowindex >= yY) {
            for (let j = xX; j <= colindex; j++) {
                for (let i = yY; i <= rowindex; i++) {
                    var item0 = this.getView().hitTagNode(x, y, i, j);
                    if (array.indexOf(item0) != -1) {
                        continue;
                    }
                    if (item0) {
                        array.push(item0);
                    }
                }
            }
        }
        if (colindex <= xX && rowindex <= yY) {
            for (let j = colindex; j <= xX; j++) {
                for (let i = rowindex; i <= yY; i++) {
                    var item1 = this.getView().hitTagNode(x, y, i, j);
                    if (array.indexOf(item1) != -1) {
                        continue;
                    }
                    if (item1) {
                        array.push(item1);
                    }
                }
            }
        }
        if (colindex >= xX && rowindex <= yY) {
            for (let j = xX; j <= colindex; j++) {
                for (let i = rowindex; i <= yY; i++) {
                    var item2 = this.getView().hitTagNode(x, y, i, j);
                    if (array.indexOf(item2) != -1) {
                        continue;
                    }
                    if (item2) {
                        array.push(item2);
                    }
                }
            }
        }
        if (colindex <= xX && rowindex >= yY) {
            for (let j = colindex; j <= xX; j++) {
                for (let i = yY; i <= rowindex; i++) {
                    var item = this.getView().hitTagNode(x, y, i, j);
                    if (array.indexOf(item) != -1) {
                        continue;
                    }
                    if (item) {
                        array.push(item);
                    }
                }
            }
        }
        //最大
        var maxX = this.startRowindex;
        var minX = this.startRowindex;
        var maxY = this.startColindex;
        var minY = this.startColindex;
        for (let i = 0; i < array.length; i++) {
            var HeadCellCell;
            var arrayElement = array[i];
            var cellView1 = PrintNodeUtil.getCellViewByTagNode(sectionView!, arrayElement);
            if (cellView1) {
                var rowIndex1 = cellView1.getRowIndex();
                var colIndex1 = cellView1.getColIndex();
                maxX = Math.max(maxX, rowIndex1);
                maxY = Math.max(maxY, colIndex1);
                minX = Math.min(minX, rowIndex1);
                minY = Math.min(minY, colIndex1);
            }
            HeadCellCell = cellView1;
            var isMerged = arrayElement.getAttributeValueBoolean(BaseConstants.ATTR_ISMERGED, false);
            if (isMerged) {//合并的单元格
                if (!arrayElement.getAttributeValueBoolean(BaseConstants.ATTR_Merged_Head, false)) {
                    var rowSpan = cellView1!.getTagNode().getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
                    var colSapn = cellView1!.getTagNode().getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);
                    var rowIndex2 = cellView1!.getRowIndex();
                    var colIndex2 = cellView1!.getColIndex();
                    var XXX = rowIndex2 - rowSpan;
                    var YYY = colIndex2 - colSapn;
                    HeadCellCell = sectionView!.locCell(XXX, YYY);
                }
                var rowSpanValue = HeadCellCell!.getTagNode().getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
                var colSpanValue = HeadCellCell!.getTagNode().getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);
                var rowIndex1 = HeadCellCell!.getRowIndex();
                var colIndex1 = HeadCellCell!.getColIndex();
                for (let j = colIndex1; j < colIndex1 + colSpanValue; j++) {
                    for (let i = rowIndex1; i < rowIndex1 + rowSpanValue; i++) {
                        var item0 = this.getView().hitTagNode(x, y, i, j);
                        if (item0) {
                            var cellViewByTagNode = PrintNodeUtil.getCellViewByTagNode(sectionView!, item0);
                            if (cellViewByTagNode) {
                                isMergeHandle = true;
                                var rowIndex = cellViewByTagNode.getRowIndex();
                                var colIndex = cellViewByTagNode.getColIndex();
                                maxX = Math.max(maxX, rowIndex);
                                maxY = Math.max(maxY, colIndex);
                                minX = Math.min(minX, rowIndex);
                                minY = Math.min(minY, colIndex);
                            }

                        }
                    }
                }
            }
        }
        //接下来处理合并单元格
        if (isMergeHandle) {
            this.selectHandle(maxY, xX, maxX, yY, sectionView, array);
            this.selectHandle(minY, xX, minX, yY, sectionView, array);
            this.selectHandle(maxY, xX, minX, yY, sectionView, array);
            this.selectHandle(minY, xX, maxX, yY, sectionView, array);

        }
        this.selects = array;
        console.log(this.selects.length);

        for (let i = 0; i < this.selects.length; i++) {
            var arrayElement1 = this.selects[i];
            selectionModel.select(arrayElement1);
        }
    }

    private selectHandle(maxY: number, xX: number, maxX: number, yY: number, sectionView: SectionView | undefined, array: any[]) {
        if (maxY >= xX && maxX >= yY) {
            for (let j = xX; j <= maxY; j++) {
                for (let i = yY; i <= maxX; i++) {
                    var item01 = sectionView!.locCell(i, j)?.getTagNode();
                    if (item01) {
                        if (array.indexOf(item01) != -1) {
                            continue;
                        }

                        array.push(item01);
                    }
                }
            }
        } else if (maxY <= xX && maxX <= yY) {
            for (let j = maxY; j <= xX; j++) {
                for (let i = maxX; i <= yY; i++) {
                    var item11 = sectionView!.locCell(i, j)?.getTagNode();
                    if (item11) {
                        if (array.indexOf(item11) != -1) {
                            continue;
                        }
                        array.push(item11);
                    }
                }
            }
        } else if (maxY >= xX && maxX <= yY) {
            for (let j = xX; j <= maxY; j++) {
                for (let i = maxX; i <= yY; i++) {
                    var item21 = sectionView!.locCell(i, j)?.getTagNode();
                    if (item21) {
                        if (array.indexOf(item21) != -1) {
                            continue;
                        }
                        array.push(item21);
                    }
                }
            }
        } else if (maxY <= xX && maxX >= yY) {
            for (let j = maxY; j <= xX; j++) {
                for (let i = yY; i <= maxX; i++) {
                    var item23 = sectionView!.locCell(i, j)?.getTagNode();
                    if (item23) {
                        if (array.indexOf(item23) != -1) {
                            continue;
                        }
                        array.push(item23);
                    }
                }
            }
        }
    }


    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        var selectionModel = this.getView().getXmlEntity().getSelectionModel();
        selectionModel.setBMultiSelection(false);
        this.getDelegate().setNormalState();
    }

    getStartX(): number {
        return this.startX;
    }

    setStartX(value: number) {
        this.startX = value;
    }

    getStartY(): number {
        return this.startY;
    }

    setStartY(value: number) {
        this.startY = value;
    }


    getEl(): any {
        return this.el;
    }

    setEl(value: any) {
        this.el = value;
    }
}
