import AbstractPrintOptState from "./AbstractPrintOptState";
import SectionView from "../view/element/SectionView";
import BaseConstants from "../../base/BaseConstants";
import SelectAreaState from "./SelectAreaState";
import ITagNode from "../../../common/xml/node/ITagNode";
import ResizeState from "./ReszieState";
import RowReszieState from "./RowReszieState";
import SizeInfo from "../../../common/struct/SizeInfo";
import {CellView} from "../view/element/CellView";

export default class NormalState extends AbstractPrintOptState {
    private startX = 0;
    private startY = 0;
    private sectionView: SectionView | undefined;
    private el: any;
    private ele: any;

    mousedown(e: MouseEvent): void {
        var selectionModel = this.getView().getXmlEntity().getSelectionModel();
        var singleSeletionItem = this.getView().getXmlEntity().getSelectionModel().getSingleSeletionItem()
        var iTagNodes = this.getView().getXmlEntity().getSelectionModel().doCacheTagNodes();
        var length = iTagNodes.length;
        this.el = <HTMLElement>e.target;
        let target = <HTMLElement>e.target;
        if (  target.className == "print-embed-comp" ||target.className == "embed-text"){
            return;
        }
        var {x, y} = this.getPosition(e);
        this.startX = x;
        this.startY = y;
        this.sectionView = this.getView().getSectionView(x, y);
        if (this.sectionView != null) {
            this.getView().setSectionView(<SectionView>this.sectionView);
            this.sectionView?.getTagNode().setSelected(true);
        }
        var rowindex1 = Number(this.el.getAttribute("rowindex"))
        var colindex1 = Number(this.el.getAttribute("colindex"))
        var hitMultiTagNode = this.getView().hitMultiTagNode(x, y);
        if (!hitMultiTagNode) {
            selectionModel.select(this.getView().getXmlEntity().getTagRoot());
            return;
        }
        var hitTagNode = this.getView().hitTagNode(x, y, rowindex1, colindex1);
        var childNode = this.sectionView!.getChildNode(rowindex1, colindex1);
        var rowindex = hitMultiTagNode!.getRowIndex();
        var colindex = hitMultiTagNode!.getColIndex();
        var startTagNode = hitMultiTagNode?.getTagNode();
        var rowSpan = startTagNode!.getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
        var colSpan = startTagNode!.getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);
        var array = new Array();
        if (startTagNode!.getAttributeValueBoolean(BaseConstants.ATTR_Merged_Head, false)) {
            this.getView().SelectCellView(<CellView>childNode);//头
            array.push(hitTagNode);
            // array.push(hitTagNode?.getTagNode());
            for (let j = colindex; j < colindex + colSpan; j++) {
                for (let i = rowindex; i < rowindex + rowSpan; i++) {
                    var item0 = this.getView().hitTagNode(x, y, i, j);
                    if (array.indexOf(item0) != -1) {
                        continue;
                    }
                    if (item0) {
                        array.push(item0);
                    }
                }
            }
            if (e.button == 0 && length == array.length &&
                singleSeletionItem?.isSelected() &&
                hitTagNode == iTagNodes[0]?.getTagNode()) {

                var childNode1 = this.sectionView?.getChildCell(rowindex1, colindex1);
                var height = SizeInfo.valueOfPX(Number($(childNode1.el).height()));
                childNode?.setStyle("display", "none");
                var textEditor = childNode1.getTextEditor();
                textEditor.setStyle("display", "block");
                textEditor.setStyle("width", "100%");
                textEditor.setStyle("height", "100%")
                textEditor.setStyle("min-height", height)
                textEditor.setStyle("disabled", "true");
                setTimeout(function () {
                    var text = childNode!.getText();
                    textEditor.setValue(text);
                    textEditor.getEl().focus();
                }, 10);
            } else {
                selectionModel.setBMultiSelection(true);
                selectionModel.unMultiSelection();
                selectionModel.setBMultiSelection(false);
                selectionModel.select(array[0]);
                selectionModel.setBMultiSelection(true);
                console.log(array.length);
                for (let i = 1; i < array.length; i++) {
                    selectionModel.select(array[i]);
                }
                selectionModel.setBMultiSelection(false);
            }
        } else if (startTagNode!.getAttributeValueBoolean(BaseConstants.ATTR_ISMERGED, false)) {//点到不是头
            this.getView().SelectCellView(<CellView>childNode);
            var locHeadCell = this.sectionView!.locCell(rowindex - rowSpan, colindex - colSpan);
            var colIndex = locHeadCell!.getColIndex();
            var rowIndex = locHeadCell!.getRowIndex();
            array.push(locHeadCell?.getTagNode());
            var rowSpanHeadCell = locHeadCell!.getTagNode().getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
            var colSpanHeadCell = locHeadCell!.getTagNode().getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);
            for (let j = colIndex; j < colIndex + colSpanHeadCell; j++) {
                for (let i = rowIndex; i < rowIndex + rowSpanHeadCell; i++) {
                    var item0 = this.getView().hitTagNode(x, y, i, j);
                    if (array.indexOf(item0) != -1) {
                        continue;
                    }
                    if (item0) {
                        array.push(item0);
                    }
                }
            }
            if (e.button == 0 && length == array.length &&
                singleSeletionItem?.isSelected() &&
                hitTagNode == iTagNodes[0]?.getTagNode()) {
                var childNode1 = this.sectionView?.getChildCell(rowindex1, colindex1);
                var height = SizeInfo.valueOfPX(Number($(childNode1.el).height()));
                childNode?.setStyle("display", "none");
                var textEditor = childNode1.getTextEditor();
                textEditor.setStyle("display", "block");
                textEditor.setStyle("width", "100%");
                textEditor.setStyle("height", "100%")
                textEditor.setStyle("min-height", height)
                textEditor.setStyle("disabled", "true");
                setTimeout(function () {
                    var text = childNode!.getText();
                    textEditor.setValue(text);
                    textEditor.getEl().focus();
                }, 10);
            } else {
                selectionModel.setBMultiSelection(true);
                selectionModel.unMultiSelection();
                selectionModel.setBMultiSelection(false);
                selectionModel.select(array[0]);
                selectionModel.setBMultiSelection(true);
                console.log(array.length);
                for (let i = 1; i < array.length; i++) {
                    selectionModel.select(array[i]);
                }
                selectionModel.setBMultiSelection(false);
            }

        } else {
            if (e.button == 0 &&
                singleSeletionItem?.isSelected() &&
                hitTagNode == iTagNodes[iTagNodes.length - 1]?.getTagNode()) {
                this.getView().SelectCellView(<CellView>childNode);
                var childNode1 = this.sectionView?.getChildCell(rowindex1, colindex1);
                var height = SizeInfo.valueOfPX(Number($(childNode1.el).height()));
                childNode?.setStyle("display", "none");
                var textEditor = childNode1.getTextEditor();
                textEditor.setStyle("display", "block");
                textEditor.setStyle("width", "100%");
                textEditor.setStyle("height", "100%")
                textEditor.setStyle("min-height", height)
                textEditor.setStyle("disabled", "true");
                setTimeout(function () {
                    var text = childNode!.getText();
                    textEditor.setValue(text);
                    textEditor.getEl().focus();
                }, 10);
            } else {
                selectionModel.setBMultiSelection(true);
                selectionModel.unMultiSelection();
                selectionModel.setBMultiSelection(false);
                selectionModel.select(hitTagNode);
                this.getView().SelectCellView(<CellView>childNode);
                //  if (this.startX != x && this.startY != y) {
                // }
            }


        }
    }

    mousemove(e: MouseEvent): void {
        var {x, y} = this.getPosition(e);
        this.ele = e.target;
        if (e.buttons != 1 && "col-resize-ltr" == this.ele.className) {
            this.getDelegate().setResizeState();
        } else if (e.buttons != 1 && this.ele.className.indexOf("row-resize-ltr") != -1) {
            this.getDelegate().setRowReszieState();
        } else if (e.button == 0 && e.buttons == 1 && Math.abs(this.startX - x) > 1 && Math.abs(this.startY - y) > 1) {
            var selectionModel = this.getView().getXmlEntity().getSelectionModel();
            selectionModel.setBMultiSelection(true);
            var selectAreaState = new SelectAreaState(this.getDelegate());
            selectAreaState.setEl(this.el);
            selectAreaState.setStartX(this.startX);
            selectAreaState.setStartY(this.startY);
            this.getDelegate().setSelectAreaState(selectAreaState);
        }
    }


    mouseup(e: MouseEvent): void {
        var selectionModel = this.getView().getXmlEntity().getSelectionModel();
        selectionModel.setBMultiSelection(false);
        var {x, y} = this.getPosition(e);
        console.log(this.startX, this.startY, x, y)
        this.reset();
    }


}
