import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";

export default class SetRowCmd implements ICmd {
    private tagNode: ITagNode;
    private xmlEntity: IXmlEntity;
    private alignmentValue: string;
    private alignmentOldValue: string;
    private alignmentType: string;

    constructor(xmlEntity: IXmlEntity, tagNode: ITagNode, alignmentValue: string, alignmentOldValue: string, alignmentType: string) {
        this.xmlEntity = xmlEntity;
        this.tagNode = tagNode;
        this.alignmentValue = alignmentValue;
        this.alignmentType = alignmentType;
        this.alignmentOldValue = alignmentOldValue;
    }

    do(): boolean {
        var parent = this.tagNode!.getParent();
        this.alignmentOldValue = parent!.getAttributeValue(this.alignmentType);
        parent!.setAttributeValue(this.alignmentType, this.alignmentValue);
        this.xmlEntity.getSelectionModel().select(this.tagNode);
        return true;
    }

    undo(): void {
        var parent = this.tagNode!.getParent();
        parent!.setAttributeValue(this.alignmentType, this.alignmentOldValue);
        this.xmlEntity.getSelectionModel().select(this.tagNode);
    }
}