import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";

export default class SetBorderCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private xmlEntity: IXmlEntity;
    private alignmentValue: string;
    private oldITagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private alignmentType: string[];
    private tagName: string;
    private defaultValue: string ;

    constructor(tagName: string, xmlEntity: IXmlEntity, tagNode: ITagNode[], alignmentValue: string, alignmentType: string[],defaultValue?:string) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
        this.alignmentValue = alignmentValue;
        this.alignmentType = alignmentType;
        this.tagName = tagName;
        if (!defaultValue){
            this.defaultValue = "";
        }else {
            this.defaultValue = defaultValue;
        }
    }

    do(): boolean {
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            if (!tagNode.getParent()) {
                continue;
            }
            if (this.tagName == "" || tagNode.getTagName() != "Cell") {
            } else {
                var split = this.tagName.split(";");
                if (tagNode!.getChild(split[0]) && tagNode!.getChild(split[0])!.getChild(split[1])) {
                    this.oldITagNodes = this.oldITagNodes || []
                    this.newITagNodes = this.newITagNodes || []
                    var child = <ITagNode>tagNode!.getChild(split[0])!.getChild(split[1]);
                    this.oldITagNodes.push(child);
                    child?.setAttributeValue(this.alignmentType[0], this.alignmentValue,this.defaultValue);
                    child?.setAttributeValue(this.alignmentType[1], this.alignmentValue,this.defaultValue);
                    child?.setAttributeValue(this.alignmentType[2], this.alignmentValue,this.defaultValue);
                    child?.setAttributeValue(this.alignmentType[3], this.alignmentValue,this.defaultValue);
                      this.newITagNodes.push(child);
                } else {
                    continue;
                }
            }
        }
        if (this.oldITagNodes) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
        return true;
    }

    undo(): void {
        if (this.iTagNodes.length <= 0 || !this.oldITagNodes || this.oldITagNodes.length <= 0) {
            return;
        }
        for (let i = 0; i < this!.newITagNodes!.length; i++) {

            var attributes = this!.newITagNodes![i]!.getAttributes();
            attributes.length = 0;
            for (let j = 0; j < this.oldITagNodes[i].getAttributes().length; j++) {
                attributes.push(this.oldITagNodes[i].getAttributes()[j]);
            }
        }
        if (this.oldITagNodes && this.oldITagNodes!.length > 0) {
            var selectionModel = this.xmlEntity.getSelectionModel();
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    }
}