
import PrintConstants from "../../print/base/PrintConstants";

export default class P18N {

    private static map: Map<string, string> = new Map([
        [PrintConstants.NODE_AddParagraph_Before, PrintConstants.C_AddParagraph_Before],
        [PrintConstants.NODE_AddParagraph_After, PrintConstants.C_AddParagraph_After],
        [PrintConstants.NODE_Paragraph_Delete, PrintConstants.C_Paragraph_Delete],

        [PrintConstants.NODE_AddRow_Before, PrintConstants.C_AddRow_Before],
        [PrintConstants.NODE_AddRow_After, PrintConstants.C_AddRow_After],
        [PrintConstants.NODE_Row_Delete, PrintConstants.C_Row_Delete],

        [PrintConstants.NODE_AddColumn_Before, PrintConstants.C_AddColumn_Before],
        [PrintConstants.NODE_AddColumn_After, PrintConstants.C_AddColumn_After],
        [PrintConstants.NODE_Column_Delete, PrintConstants.C_Column_Delete],

        [PrintConstants.NODE_Cell_Data, PrintConstants.C_Cell_Data],
        [PrintConstants.NODE_Cell_DataStyle, PrintConstants.C_Cell_DataStyle],
        [PrintConstants.NODE_Cell_ViewStyle, PrintConstants.C_Cell_ViewStyle],
        [PrintConstants.NODE_Cell_Border, PrintConstants.C_Cell_Border],

        [PrintConstants.NODE_Para_Porporty, PrintConstants.C_Para_Porporty],
        [PrintConstants.NODE_Row_Porporty, PrintConstants.C_Row_Porporty],
        [PrintConstants.NODE_Column_Porporty, PrintConstants.C_Column_Porporty],

        [PrintConstants.Node_Page_Opt, PrintConstants.C_Page_Opt],
        [PrintConstants.Node_Paper_Opt, PrintConstants.C_Paper_Opt],

    ]);

    public static register(key: string, text: string) {
        P18N.map.set(key, text);
    }

    public static getString(key: string): string {
        var v = P18N.map.get(key);
        if (!v)  {
            v = P18N.map.get(key.toLowerCase());
            if (!v) {
                return key;
            }
        }
        return v;
    }
}