import CodeMirror from "codemirror";
import AbstractResourceLoader from "./AbstractResourceLoader";

export default class CodeMirrorLoader extends AbstractResourceLoader {

    protected getJSLinkArray(): string[] {
        var needLoadCodeMirrorJS = (CodeMirror == undefined || CodeMirror == null);
        return [
            needLoadCodeMirrorJS ? this.webRoot + 'lib/map/codemirror/lib/codemirror.js' : '' ,
            this.webRoot + 'lib/map/codemirror/mode/clike/clike.js',
            this.webRoot + 'lib/map/codemirror/mode/javascript/javascript.js',
            this.webRoot + 'lib/map/codemirror/mode/sql/sql.js',
            this.webRoot + 'lib/map/codemirror/addon/fold/foldcode.js',
            this.webRoot + 'lib/map/codemirror/addon/fold/foldgutter.js',
            this.webRoot + 'lib/map/codemirror/addon/fold/brace-fold.js',
            this.webRoot + 'lib/map/codemirror/addon/fold/comment-fold.js',
            this.webRoot + 'lib/map/codemirror/addon/hint/show-hint.js',
            this.webRoot + 'lib/map/codemirror/addon/hint/sql-hint.js',
            this.webRoot + 'lib/map/codemirror/addon/hint/javascript-hint.js',
            this.webRoot + 'lib/map/codemirror/addon/hint/anyword-hint.js',
            this.webRoot + 'lib/map/codemirror/addon/hint/function-hint.js',
            this.webRoot + 'lib/map/codemirror/addon/edit/matchbrackets.js',
            this.webRoot + 'lib/map/codemirror/addon/edit/closebrackets.js',
            this.webRoot + 'lib/map/codemirror/addon/edit/closetag.js',
            this.webRoot + 'lib/map/codemirror/addon/selection/active-line.js',
            this.webRoot + 'lib/map/codemirror/mode/yigo/yigo.js',
            this.webRoot + 'lib/map/codemirror/mode/markdown/markdown.js',
            this.webRoot + 'lib/map/codemirror/addon/lint/lint.js',
            this.webRoot + 'lib/map/codemirror/addon/hover/text-hover.js',
            this.webRoot + 'lib/map/codemirror/addon/hover/token-hover.js',
            this.webRoot + 'lib/map/codemirror/addon/dialog/dialog.js',
            this.webRoot + 'lib/map/codemirror/addon/scroll/simplescrollbars.js',
            this.webRoot + 'lib/map/codemirror/addon/selection/active-line.js',
            this.webRoot + 'lib/map/codemirror/mode/xml/xml.js',
            this.webRoot + 'lib/map/codemirror/addon/fold/xml-fold.js',
            this.webRoot + 'lib/map/codemirror/addon/search/search.js',
            this.webRoot + 'lib/map/codemirror/addon/search/searchcursor.js',
            this.webRoot + 'lib/map/codemirror/addon/search/jump-to-line.js',
            this.webRoot + 'lib/map/codemirror/addon/search/matchesonscrollbar.js',
            this.webRoot + 'lib/map/codemirror/addon/search/match-highlighter.js',
            this.webRoot + 'lib/map/codemirror/addon/scroll/annotatescrollbar.js'
        ];
    }

    protected getCssLinkArray(): string[] {
        return [
            this.webRoot + 'lib/map/codemirror/lib/codemirror.css',
            this.webRoot + 'lib/map/codemirror/theme/dracula.css',
            this.webRoot + 'lib/map/codemirror/addon/fold/foldgutter.css',
            this.webRoot + 'lib/map/codemirror/addon/hint/show-hint.css',
            this.webRoot + 'lib/map/codemirror/addon/lint/lint.css',
            this.webRoot + 'lib/map/codemirror/addon/hover/text-hover.css',
            this.webRoot + 'lib/map/codemirror/theme/material.css',
            this.webRoot + 'lib/map/codemirror/addon/dialog/dialog.css',
            this.webRoot + 'lib/map/codemirror/addon/scroll/simplescrollbars.css',
            this.webRoot + 'lib/map/codemirror/addon/search/matchesonscrollbar.css'
        ];
    }
}