import IGElement from "../../../../common/ui/graphic/IGElement";
import IGSection from "../../../../common/ui/graphic/IGSection";
import GElement from "./GElement";

export default class GSection extends GElement implements IGSection {

    private paper: Snap.Paper;

    constructor(section: Snap.Paper) {
        super(section);
        this.paper = <Snap.Paper> this.getGNode();
    }

    section(varargs?: any): IGSection {
        //var el = document.createElement('g');
        //this.paper.add(el);
        var section = this.paper.g();
        return new GSection(section);
    }

    circle(x: number, y: number, r: number): IGElement {
        var elem = this.paper.circle(x, y, r);
        return new GElement(elem);
    }

    ellipse(x: number, y: number, rx: number, ry: number): IGElement {
        var elem = this.paper.ellipse(x, y, rx, ry);
        return new GElement(elem);
    }

    image(src: string, x: number, y: number, width: number, height: number): IGElement {
        var elem = this.paper.image(src, x, y, width, height);
        return new GElement(elem);
    }

    line(x1: number, y1: number, x2: number, y2: number): IGElement {
        var elem = this.paper.line(x1, y1, x2, y2);
        return new GElement(elem);
    }

    path(pathSpec: string | (string | number)[][]): IGElement {
        var elem = this.paper.path(pathSpec);
        return new GElement(elem);
    }

    polygon(varargs: any[]): IGElement {
        var elem = this.paper.polygon(varargs);
        return new GElement(elem);
    }

    polyline(varargs: any[]): IGElement {
        var elem = this.paper.polyline(varargs);
        return new GElement(elem);
    }

    rect(x: number, y: number, width: number, height: number, rx?: number, ry?: number): IGElement {
        var elem = this.paper.rect(x, y, width, height, rx, ry);
        return new GElement(elem);
    }

    text(x: number, y: number, text: string | number): IGElement;
    text(x: number, y: number, text: (string | number)[]): IGElement;
    text(x: any, y: any, text: any): IGElement {
        var elem = this.paper.text(x, y, text);
        return new GElement(elem);
    }
    
    symbol(vbx: number, vby: number, vbw: number, vbh: number): IGElement {
        var elem = this.paper.symbol(vbx, vby, vbw, vbh);
        return new GElement(elem);
    }

    clear(): void {
        this.paper.clear();
    }
}