import ArrayList from "../../../../common/struct/ArrayList";
import GBox from "../../../../common/ui/graphic/GBox";
import IGElement from "../../../../common/ui/graphic/IGElement";

export default class GElement implements IGElement {

    private snapEl: Snap.Element;

    private children: ArrayList<IGElement>;

    constructor(snapEl: Snap.Element) {
        this.snapEl = snapEl;
        this.children = new ArrayList<IGElement>();
    }

    setVisiable(visible: boolean): void {
        this.getHtmlElement().style['display'] = visible ? 'block' : 'none';
    }

    isVisiable(): boolean {
        var display = this.getHtmlElement().style['display'];
        return display != 'none';
    }

    add(gl: IGElement): IGElement {
        this.children.add(gl);
        var node = <Snap.Element> gl.getGNode();
        this.snapEl.add(node);
        return this;
    }

    getChildren(): IGElement[] {
        return this.children.getList();
    }

    remove(): IGElement {
        this.children.clearAll();
        this.snapEl.remove();
        return this;
    }

    getGNode(): Snap.Element {
        return this.snapEl;
    }

    getHtmlElement(): HTMLElement {
        return this.snapEl.node; 
    }

    getBBox(): GBox {
        return this.snapEl.getBBox();
    }

    transformTo(x: number, y: number): IGElement {
        this.snapEl.attr({transform: 'T' + [x, y]});
        return this;
    }

    transform(a:number,x?:number,y?:number): IGElement {
        //@ts-ignore
        var matrix = Snap.matrix();
        matrix.rotate(a, x, y);
        this.snapEl.transform(matrix.toTransformString());
        return this;
    }

    addClass(cls:string): GElement {
        this.snapEl.addClass(cls);
        return this;
    }

    attr(params: { [attr: string]: any; }): IGElement {
        this.snapEl.attr(params);
        return this;
    }

    click(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.click(handler, thisArg);
        return this;
    }

    dblclick(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.dblclick(handler, thisArg);
        return this;
    }

    mousedown(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.mousedown(handler, thisArg);
        return this;
    }

    mousemove(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.mousemove(handler, thisArg);
        return this;
    }

    mouseout(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.mouseout(handler, thisArg);
        return this;
    }

    mouseover(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.mouseover(handler, thisArg);
        return this;
    }

    mouseup(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.mouseup(handler, thisArg);
        return this;
    }

    touchstart(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.touchstart(handler, thisArg);
        return this;
    }

    touchmove(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.touchmove(handler, thisArg);
        return this;
    }

    touchend(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.touchend(handler, thisArg);
        return this;
    }
    
    touchcancel(handler: (event: MouseEvent) => void, thisArg?: any): IGElement {
        this.snapEl.touchcancel(handler, thisArg);
        return this;
    }

    hover(hoverInHandler: (event: MouseEvent) => void, hoverOutHandler: (event: MouseEvent) => void, inThisArg?: any, outThisArg?: any): IGElement {
        this.snapEl.hover(hoverInHandler, hoverOutHandler, inThisArg, outThisArg);
        return this;
    }

    drag(): IGElement;
    drag(onMove: (dx: number, dy: number, x: number, y: number, event: MouseEvent) => void, onStart: (x: number, y: number, event: MouseEvent) => void, onEnd: (event: MouseEvent) => void, moveThisArg?: any, startThisArg?: any, endThisArg?: any): IGElement;
    drag(onMove?: any, onStart?: any, onEnd?: any, moveThisArg?: any, startThisArg?: any, endThisArg?: any): IGElement {
       this.snapEl.drag(onMove, onStart, onEnd, moveThisArg, startThisArg, endThisArg)
       return this;
    }

}