import PrintNodeUtil from "../../print/util/PrintNodeUtil";

import SectionView from "../../print/view/element/SectionView";
import {CellView} from "../../print/view/element/CellView";
import BaseConstants from "../../base/BaseConstants";
import AbstractExcelOptState from "./AbstractExcelOptState";
import ITagNode from "../../../common/xml/node/ITagNode";
import SheetView from "../view/element/SheetView";
import {ExcelCellView} from "../view/element/ExcelCellView";
import ExcelGraphicView from "../view/ExcelGraphicView";
import DomUtil from "../../../common/dom/DomUtil";


export default class SelectAreaState extends AbstractExcelOptState {

    private startX = 0;

    private startY = 0;

    private startRowindex: number = 0;
    private startColindex: number = 0;
    private selects: Array<any> | undefined;

    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
    }

    mousemove(e: MouseEvent): void {
        if (!(e.button == 0 && e.buttons == 1)) {
            var selectionModel = this.getView().getXmlEntity().getSelectionModel();
            selectionModel.setBMultiSelection(false);
            this.getDelegate().setNormalState();
            return;
        }
        var el = <HTMLElement>e.target;
        if (el.tagName == "IMG") {
            return;
        }
        var {x, y} = this.getPosition(e);
        this.startRowindex = Number(el.getAttribute("rowindex"));
        this.startColindex = Number(el.getAttribute("colindex"));

        var hitMultiTag = <ExcelCellView>this.getView().hitMultiTagNode(x, y);

        if (!hitMultiTag) {
            return;
        }
        var rowindex = hitMultiTag.getRowIndex();
        var colindex = hitMultiTag.getColIndex();
        var selectSheetView = <SheetView>this.getView().getSelectSheetView();
        var selectionModel = this.getView().getXmlEntity().getSelectionModel();
        selectionModel.setBMultiSelection(true);
        var xX = this.startY;//0
        var yY = this.startX;//1
        this.getView().getXmlEntity().getSelectionModel().unMultiSelection();
        var array = new Array<any>();
        if (colindex >= xX && rowindex >= yY) {
            for (let j = xX; j <= colindex; j++) {
                for (let i = yY; i <= rowindex; i++) {
                    var item0 = this.getView().hitTagNode(i, j);
                    if (array.indexOf(item0) != -1) {
                        continue;
                    }
                    if (item0) {
                        array.push(item0);
                    }
                }
            }
        }
        if (colindex <= xX && rowindex <= yY) {
            for (let j = colindex; j <= xX; j++) {
                for (let i = rowindex; i <= yY; i++) {
                    var item1 = this.getView().hitTagNode(i, j);
                    if (array.indexOf(item1) != -1) {
                        continue;
                    }
                    if (item1) {
                        array.push(item1);
                    }
                }
            }
        }
        if (colindex >= xX && rowindex <= yY) {
            for (let j = xX; j <= colindex; j++) {
                for (let i = rowindex; i <= yY; i++) {
                    var item2 = this.getView().hitTagNode(i, j);
                    if (array.indexOf(item2) != -1) {
                        continue;
                    }
                    if (item2) {
                        array.push(item2);
                    }
                }
            }
        }
        if (colindex <= xX && rowindex >= yY) {
            for (let j = colindex; j <= xX; j++) {
                for (let i = yY; i <= rowindex; i++) {
                    var item = this.getView().hitTagNode(i, j);
                    if (array.indexOf(item) != -1) {
                        continue;
                    }
                    if (item) {
                        array.push(item);
                    }
                }
            }
        }
        this.selects = array;
        //最大
        var maxX = yY;
        var minX = yY;
        var maxY = xX;
        var minY = xX;
        var isMergeHandle = false;
        var hitMultiTagNode;
        var isMergeHandleList = [];
        while (hitMultiTagNode = array.pop()) {
            isMergeHandle = false;
            var megerHeadRowindex = hitMultiTagNode.getMegerHeadRowindex();
            var megerHeadColindex = hitMultiTagNode.getMegerHeadColindex();
            var hitMultiRowindex = hitMultiTagNode!.getRowIndex();
            var hitMultiColindex = hitMultiTagNode!.getColIndex();
            var startTagNode = hitMultiTagNode?.getTagNode();
            var rowSpan = startTagNode!.getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
            var colSpan = startTagNode!.getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);

            if (maxX < hitMultiRowindex || minY > hitMultiColindex || minX > hitMultiRowindex || maxY < hitMultiColindex) {
                isMergeHandle = true;
            }
            maxX = Math.max(maxX, hitMultiRowindex);
            maxY = Math.max(maxY, hitMultiColindex);
            minX = Math.min(minX, hitMultiRowindex);
            minY = Math.min(minY, hitMultiColindex);

            if (megerHeadRowindex > 0 || megerHeadColindex > 0) {
                var HeadMergerTagNode = <ExcelCellView>selectSheetView.getChildNode(megerHeadRowindex, megerHeadColindex);//头;
                if (isMergeHandleList.indexOf(hitMultiTagNode) != -1) {
                    continue;
                } else {
                    isMergeHandleList.push(hitMultiTagNode);
                }
                var HeadTagNode = HeadMergerTagNode.getTagNode();
                var row = HeadTagNode!.getAttributeValueInt(BaseConstants.ATTR_RowSpan, 0);
                var col = HeadTagNode!.getAttributeValueInt(BaseConstants.ATTR_ColSpan, 0);
                maxX = Math.max(maxX, megerHeadRowindex);
                maxY = Math.max(maxY, megerHeadColindex);
                minX = Math.min(minX, megerHeadRowindex);
                minY = Math.min(minY, megerHeadColindex);
                if (row > 0 || col > 0) {
                    if (row > 0 && col == 0) {
                        maxX = Math.max(maxX, megerHeadRowindex + row - 1);
                        maxY = Math.max(maxY, megerHeadColindex + col);
                        minX = Math.min(minX, megerHeadRowindex + row - 1);
                        minY = Math.min(minY, megerHeadColindex + col);
                    } else if (row == 0 && col > 0) {
                        maxX = Math.max(maxX, megerHeadRowindex + row);
                        maxY = Math.max(maxY, megerHeadColindex + col - 1);
                        minX = Math.min(minX, megerHeadRowindex + row);
                        minY = Math.min(minY, megerHeadColindex + col - 1);
                    } else {
                        maxX = Math.max(maxX, megerHeadRowindex + row - 1);
                        maxY = Math.max(maxY, megerHeadColindex + col - 1);
                        minX = Math.min(minX, megerHeadRowindex + row - 1);
                        minY = Math.min(minY, megerHeadColindex + col - 1);
                    }
                }
                isMergeHandle = true;
            } else if (rowSpan > 0 || colSpan > 0) {//头
                if (isMergeHandleList.indexOf(hitMultiTagNode) != -1) {
                    continue;
                } else {
                    isMergeHandleList.push(hitMultiTagNode);
                }
                if (rowSpan > 0 && colSpan == 0) {
                    maxX = Math.max(maxX, hitMultiRowindex + rowSpan - 1);
                    maxY = Math.max(maxY, hitMultiColindex + colSpan);
                    minX = Math.min(minX, hitMultiRowindex + rowSpan - 1);
                    minY = Math.min(minY, hitMultiColindex + colSpan);
                } else if (rowSpan == 0 && colSpan > 0) {
                    maxX = Math.max(maxX, hitMultiRowindex + rowSpan);
                    maxY = Math.max(maxY, hitMultiColindex + colSpan - 1);
                    minX = Math.min(minX, hitMultiRowindex + rowSpan);
                    minY = Math.min(minY, hitMultiColindex + colSpan - 1);
                } else {
                    maxX = Math.max(maxX, hitMultiRowindex + rowSpan - 1);
                    maxY = Math.max(maxY, hitMultiColindex + colSpan - 1);
                    minX = Math.min(minX, hitMultiRowindex + rowSpan - 1);
                    minY = Math.min(minY, hitMultiColindex + colSpan - 1);
                }


                isMergeHandle = true;
            } else if (!isMergeHandle) {
                continue;
            }
            //接下来处理合并单元格
            if (isMergeHandle) {
                this.selectHandle(maxY, xX, maxX, yY, this.getView(), array);
                this.selectHandle(minY, xX, minX, yY, this.getView(), array);
                this.selectHandle(maxY, xX, minX, yY, this.getView(), array);
                this.selectHandle(minY, xX, maxX, yY, this.getView(), array);

            }
            if (array.length == 0) break;
        }
        //接下来处理合并单元格

        this.selectHandle(maxY, xX, maxX, yY, this.getView(), array);
        this.selectHandle(minY, xX, minX, yY, this.getView(), array);
        this.selectHandle(maxY, xX, minX, yY, this.getView(), array);
        this.selectHandle(minY, xX, maxX, yY, this.getView(), array);


        this.selects = array;

        for (let i = 0; i < this.selects.length; i++) {
            var arrayElement1 = <ITagNode>this.selects[i].getTagNode();
            selectionModel.select(arrayElement1);
        }
    }

    private selectHandle(maxY: number, xX: number, maxX: number, yY: number, selectSheetView: ExcelGraphicView | undefined, array: any[]) {
        if (maxY >= xX && maxX >= yY) {
            for (let j = xX; j <= maxY; j++) {
                for (let i = yY; i <= maxX; i++) {
                    var item01 = selectSheetView!.hitTagNode(i, j);
                    if (item01) {
                        if (array.indexOf(item01) != -1) {
                            continue;
                        }
                        array.push(item01);
                    }
                }
            }
        } else if (maxY <= xX && maxX <= yY) {
            for (let j = maxY; j <= xX; j++) {
                for (let i = maxX; i <= yY; i++) {
                    var item11 = selectSheetView!.hitTagNode(i, j);
                    if (item11) {
                        if (array.indexOf(item11) != -1) {
                            continue;
                        }
                        array.push(item11);
                    }
                }
            }
        } else if (maxY >= xX && maxX <= yY) {
            for (let j = xX; j <= maxY; j++) {
                for (let i = maxX; i <= yY; i++) {
                    var item21 = selectSheetView!.hitTagNode(i, j);
                    if (item21) {
                        if (array.indexOf(item21) != -1) {
                            continue;
                        }
                        array.push(item21);
                    }
                }
            }
        } else if (maxY <= xX && maxX >= yY) {
            for (let j = maxY; j <= xX; j++) {
                for (let i = yY; i <= maxX; i++) {
                    var item23 = selectSheetView!.hitTagNode(i, j);
                    if (item23) {
                        if (array.indexOf(item23) != -1) {
                            continue;
                        }
                        array.push(item23);
                    }
                }
            }
        }
    }


    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        var selectionModel = this.getView().getXmlEntity().getSelectionModel();
        selectionModel.setBMultiSelection(false);
        this.getDelegate().setNormalState();
    }

    getStartX(): number {
        return this.startX;
    }

    setStartX(value: number) {
        this.startX = value;
    }

    getStartY(): number {
        return this.startY;
    }

    setStartY(value: number) {
        this.startY = value;
    }

}
