import AbstractPrintOptState from "../../print/state/AbstractPrintOptState";
import ITagNode from "../../../common/xml/node/ITagNode";
import BaseConstants from "../../base/BaseConstants";
import AbstractExcelOptState from "./AbstractExcelOptState";
import PrintConstants from "../../print/base/PrintConstants";
import EXCEL from "../base/EXCEL";
import ExcelConstants from "../base/ExcelConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import SheetView from "../view/element/SheetView";


export default class DragColumnState extends AbstractExcelOptState {

    private start: number = -1;
    private tagNode? : ITagNode;
    private el: any;
    private startNode? :ITagNode;
    private endNode? :ITagNode;
    mousedown(e: MouseEvent): void {
        super.mousedown(e);
        var {x, y} = this.getPosition(e);
        let selectSheetViewName = this.getView().getSelectSheetViewName();
        let tagRoot = this.getView().getXmlEntity().getTagRoot();
        let children = tagRoot.getChildren();
        let sheetNode;
        for (let child of children) {
            let sheet = <ITagNode>child;
            let key = sheet.getAttributeValue(BaseConstants.ATTR_Name);
            if (key == selectSheetViewName) {
                sheetNode = sheet;
                break;
            }
        }
        this.tagNode= sheetNode;
        let parentNode =<HTMLElement>((<HTMLElement>e.target).parentNode);
        let colindex = Number(parentNode.getAttribute("colindex"));
        let column ;
        let colsNode = <ITagNode>this.tagNode!.getChildren()[1];
        if (colsNode){
            let cols = colsNode!.getChildren();
            for (let col of cols) {
                let coll = <ITagNode>col
                let colin = Number(coll.getAttributeValue(ExcelConstants.ATTR_ColumnIndex));
                if (colin && colin == colindex){
                    column = coll;
                    break;
                }
            }
            if (column){
                this.startNode = XmlEntity.parseTagNode(column.toXml(true));
            }
        }
        this.el = e.target;
        this.start = x;
    }

    mousemove(e: MouseEvent): void {
        let ele = <HTMLElement>e.target;
        if (e.button == 0 && e.buttons == 1){
            var {x, y} = this.getPosition(e);
            let sheetNode =this.tagNode!;
            let length: number = this.start - x;
            let number = Math.abs(length);
            let el = <HTMLElement>this.getEl();
            let parentNode =  <HTMLElement>el.parentNode;
            let colindex = Number(parentNode.getAttribute("colindex"));
            let column ;
            let colsNode = <ITagNode>sheetNode.getChildren()[1];
            if (!colsNode){
                colsNode = this.getView().getXmlEntity().getNodeFactory().createTagNode(ExcelConstants.NODE_Columns)
                colsNode.setParent(sheetNode);
                sheetNode.addChild(colsNode);
                this.getView().getXmlEntity().update(sheetNode, true);
            }else{
                let cols = colsNode!.getChildren();
                for (let col of cols) {
                    let coll = <ITagNode>col
                    let colin = Number(coll.getAttributeValue(ExcelConstants.ATTR_ColumnIndex));
                    if (colin && colin == colindex){
                        column = coll;
                        break;
                    }
                }
            }
            if (!column){
                let  columnNode = this.getView().getXmlEntity().getNodeFactory().createTagNode(ExcelConstants.NODE_Column);
                columnNode.setParent(colsNode);
                columnNode.setAttributeValue(BaseConstants.ATTR_Width, (number+EXCEL.D_COLUMN_WIDTH).toString());
                columnNode.setAttributeValue(ExcelConstants.ATTR_ColumnIndex, colindex.toString());
                colsNode.addChild(columnNode);
                this.getView().getXmlEntity().update(colsNode, true);
                this.start =x
                this.endNode =   columnNode;
            }else {
                let  columnNode =<ITagNode>column;
                let orgLength = columnNode.getAttributeValueInt(BaseConstants.ATTR_Width, EXCEL.D_COLUMN_WIDTH);
                if (length > 0) {//缩小
                    if ((orgLength - number) > 10) {
                        let newLength = orgLength - number;
                        columnNode.setAttributeValue(BaseConstants.ATTR_Width, newLength.toString());
                        this.getView().getXmlEntity().update(columnNode, true);
                        this.start =x
                    }
                }else{//拉大
                    let newLength = orgLength + number;
                    columnNode.setAttributeValue(BaseConstants.ATTR_Width, newLength.toString());
                    this.getView().getXmlEntity().update(columnNode, true);
                    this.start =x
                }
              this.endNode =   columnNode;
            }
            var selectionModel = this.getView().getXmlEntity().getSelectionModel();
            var selectSheetView = <SheetView>this.getView().getSelectSheetView();
            selectionModel.select(selectSheetView.getTagNode());
        }else if ("excel-dragRow" == ele.className && e.buttons != 1) {
            this.getDelegate().setRragRowState();
        } else if ("excel-dragColumn" == ele.className && e.buttons != 1) {
            this.getDelegate().setDragColumnState();
        } else if (ele.nodeName == "TH" && e.buttons != 1) {
            this.getDelegate().setExcelThEventState();
        } else if (e.buttons != 1) {
            this.getDelegate().setNormalState();
        }
    }

    mouseup(e: MouseEvent): void {
        super.mouseup(e);
        this.getView().initDragState(this.getView(),this.startNode!,this.endNode!)
    }





    getTagNode(): any {
        return this.tagNode;
    }

    seTagNode(value: any) {
        this.tagNode = value;
    }


    getEl(): any {
        return this.el;
    }

    setEl(value: any) {
        this.el = value;
    }getStart(): any {
        return this.start;
    }

    setStart(value: any) {
        this.start = value;
    }
}

