import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import BaseConstants from "../../base/BaseConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import SheetView from "../view/element/SheetView";
import ExcelGraphicView from "../view/ExcelGraphicView";

export default class DivisionCellCmd implements ICmd {
    private iTagNodes: ITagNode[];
    private oldITagNodes?: ITagNode[];
    private newITagNodes?: ITagNode[];
    private xmlEntity: IXmlEntity;
    private view: ExcelGraphicView;

    constructor(view:ExcelGraphicView,xmlEntity: IXmlEntity, tagNode: ITagNode[]) {
        this.xmlEntity = xmlEntity;
        this.iTagNodes = tagNode;
        this.view = view;
    }

    do(): boolean {
        if (this.iTagNodes.length <= 0) {
            return false;
        }
        var selectionModel = this.xmlEntity.getSelectionModel();
        for (let i = 0; i < this.iTagNodes.length; i++) {
            var tagNode: ITagNode | null = this.iTagNodes[i];
            if (!(tagNode.getAttributeValueInt(BaseConstants.ATTR_RowSpan, 1) > 1 || tagNode.getAttributeValueInt(BaseConstants.ATTR_ColSpan, 1) > 1)) {
                continue;
            }
            this.oldITagNodes = this.oldITagNodes || []
            this.newITagNodes = this.newITagNodes || []
            this.oldITagNodes.push(XmlEntity.parseTagNode(tagNode.toXml(true)));
            tagNode.removeAttribute(BaseConstants.ATTR_RowSpan);
            tagNode.removeAttribute(BaseConstants.ATTR_ColSpan);
            this.newITagNodes.push(tagNode);
        }

        if (this.oldITagNodes) {
            this.view.loadSheetView(this.view.getXmlEntity())
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
        }
        selectionModel.setBMultiSelection(false);
        return true;
    }

    undo(): void {
        if (this.iTagNodes.length <= 0) {
            return;
        }
        if (this.oldITagNodes && this.oldITagNodes!.length > 0) {
            for (let i = 0; i < this!.newITagNodes!.length; i++) {

                var attributes = this!.newITagNodes![i]!.getAttributes();
                attributes.length = 0;
                for (let j = 0; j < this.oldITagNodes[i].getAttributes().length; j++) {
                    attributes.push(this.oldITagNodes[i].getAttributes()[j]);
                }
            }
            var selectionModel = this.xmlEntity.getSelectionModel();
            this.view.loadSheetView(this.view.getXmlEntity())
            selectionModel.setBMultiSelection(true);
            this.xmlEntity.getSelectionModel().unMultiSelection();
            selectionModel.setBMultiSelection(false);
            selectionModel.select(this.iTagNodes[0]);
            selectionModel.setBMultiSelection(true);
            for (let i = 1; i < this.iTagNodes.length; i++) {
                selectionModel.select(this.iTagNodes[i]);
            }
            selectionModel.setBMultiSelection(false);
        }
    }
}