import ExcelConstants from "./ExcelConstants";


export default class P18N {

    private static map: Map<string, string> = new Map([
        [ExcelConstants.Node_Cell_Porperty, ExcelConstants.C_Cell_Porperty],
        [ExcelConstants.Node_Cell_Expand, ExcelConstants.C_Cell_Expand],
        [ExcelConstants.Node_ColAndRow_Size, ExcelConstants.C_ColAndRow_Size],

        [ExcelConstants.Node_Template_Porperty, ExcelConstants.C_Template_Porperty],
        [ExcelConstants.Node_Add_Row, ExcelConstants.C_Add_Row],
        [ExcelConstants.Node_Remove_Row, ExcelConstants.C_Remove_Row],

        [ExcelConstants.Node_Add_Column, ExcelConstants.C_Add_Column],
        [ExcelConstants.Node_Remove_Column, ExcelConstants.C_Remove_Column],
        [ExcelConstants.Node_Eliminate_Cell, ExcelConstants.C_Eliminate_Cell],


    ]);
    private static colormap: Map<string, string> = new Map([
        ["BRIGHT_GREEN", "rgb(144,238,144)"],
        ["DARK_RED", "rgb(139,0,0)"],
        ["GREEN", "rgb(0,128,0)"],
        ["DARK_BLUE", "rgb(0,0,139)"],
        ["DARK_YELLOW", "rgb(250,250,210)"],
        ["GREY_25_PERCENT", "rgb(112,128,144)"],
        ["GREY_50_PERCENT", "rgb(211,211,211)"],
        ["CORNFLOWER_BLUE", "rgb(100,149,237)"],
        ["LEMON_CHIFFON", "rgb(255,250,205)"],
        ["ROYAL_BLUE", "rgb(65,105,225)"],
        ["LIGHT_CORNFLOWER_BLUE", "rgb(176,196,222)"],
        ["SKY_BLUE", "rgb(135,206,235)"],
        ["LIGHT_TURQUOISE", "rgb(175,238,238)"],
        ["LIGHT_GREEN", "rgb(144,238,144)"],
        ["LIGHT_YELLOW", "rgb(255,255,224)"],
        ["PALE_BLUE", "rgb(255,105,180)"],
        ["LIGHT_BLUE", "rgb(173,216,230)"],
        ["LIGHT_ORANGE", "rgb(255,69,0)"],
        ["BLUE_GREY", "rgb(138,43,226)"],
        ["GREY_40_PERCENT", "rgb(119,136,153)"],
        ["DARK_TEAL", "rgb(47,79,79)"],
        ["SEA_GREEN", "rgb(46,139,87)"],
        ["DARK_GREEN", "rgb(0,100,0)"],
        ["OLIVE_GREEN", "rgb(85,107,47)"],
        ["GREY_80_PERCENT", "rgb(60,90,90)"],
        ["ROSE", "rgb(255,105,180)"],

    ]);

    public static register(key: string, text: string) {
        P18N.map.set(key, text);
        P18N.colormap.set(key, text);
    }

    public static getString(key: string): string {
        var v = P18N.map.get(key);
        if (!v)  {
            v = P18N.map.get(key.toLowerCase());
            if (!v) {
                return key;
            }
        }
        return v;
    }
    public static getColorString(key: string): string {
        var v = P18N.colormap.get(key);
        if (!v)  {
            v = P18N.colormap.get(key.toLowerCase());
            if (!v) {
                return key;
            }
        }
        return v;
    }
}