import GlobalConstants from "../../../../../common/struct/GlobalConstants";
import { Area, Point } from "../../../../../common/struct/Structs";
import IGElement from "../../../../../common/ui/graphic/IGElement";
import IGSection from "../../../../../common/ui/graphic/IGSection";
import MathUtil from "../../../../../common/util/MathUtil";
import ITagNode from "../../../../../common/xml/node/ITagNode";
import TagNode from "../../../../../common/xml/node/TagNode";

import AbstractMigrationElement from "../AbstractMigrationElement";
import AbstractNode from "../../../../bpm/view/element/node/AbstractNode";
import WfDefines from "../../../../bpm/base/WfDefines";
import I18N from "../../../../bpm/base/I18N";
import WfConstants from "../../../../bpm/base/WfConstants";
import IGTable from "../../../../../common/ui/graphic/IGTable";
import RectBound from "../../../../../common/struct/RectBound";


export default abstract class AbstractLink extends AbstractMigrationElement {

    protected normalStrokeColor: string = WfDefines.G_COLOR_STROKE_NORMAL;

    private normalStrokeWidth:number = WfDefines.G_WIDTH_STROKE_NORMAL;
    
    private arrowStyle = {};

    protected toNode?: AbstractNode;

    protected fromNode?: AbstractNode;
    protected fromEvent?: RectBound;
    protected toEvent?: RectBound;

    private selectSymbo?: IGTable;

    protected group!: {line: IGTable, hide: IGTable, triangle: IGTable,
                    };

    constructor() {
        super();
    }

    public drawGraphic(): IGTable {
        this.group = {
            line: this.gSection.path(""),
            hide: this.gSection.path(""),
            triangle: this.gSection.path(""),
        };
        /*this.selectSymbo = this.gSection.section()
        this.selectSymbo.add(this.group.fromHandler);
        this.selectSymbo.add(this.group.toHandler);
        this.selectSymbo.add(this.group.optSymbo);*/
        return this.group.line;
    }
    protected getWidth(): number {
        return 0;
    }
    protected getHeight(): number {
        return 0;
    }


    private isNeedHideCaption(): boolean {
        return this.isDefaultCaption() && this.isDefaultCondition();
    }

    initGSection(section: IGTable): void {
        super.initGSection(section);
        this.dblClickHandler && this.getGCaption()?.dblclick(this.dblClickHandler)
    }

    updateCaptionLoc() {
        var center = this.getCenter();
        var gCaption = this.getGCaption();
        gCaption?.attr({x: center.x, y: center.y - 10});

        var bHideCaption = this.isNeedHideCaption();
        var showCaption = (!bHideCaption && this.isDefaultCaption()) ? this.getCondition() : this.getCaption();
        !bHideCaption && this.updateCaption(I18N.getString(showCaption));
        gCaption?.setVisiable(!bHideCaption);
        
        if (this.fromNode && this.toNode) {
            var pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
            var tan = MathUtil.tan(pos.x1, pos.y1, pos.x2, pos.y2);
            var d = Math.atan(tan) * 180/ Math.PI;

            if ((d >=0 && d<=45) || 
                (d >=135 && d <= 180)) {
                gCaption?.transform(d, center.x + 8, center.y - 8);
            } else {
                gCaption?.transform(d, center.x, center.y);
            }
        } 
    }

    getCaptionArea(): Area {
        var center = this.getCenter();
        return {
            x: center.x, 
            y: center.y,
            width: 80, 
            height: 30
        };
    }

    getCenter(): Point {
        var cx = 0, cy = 0;
        if (this.fromNode && this.toNode) {
            var pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
            cx = (pos.x1 + pos.x2) / 2;
            cy = (pos.y1 + pos.y2) / 2;
        }
        return { x: cx, y: cy };
    }

    setLocation(x: number, y: number) {
    }

    protected drawSymbo(): void {
    }

    public getFromID(): string | undefined {
        var tagNode = this.getTagNode();
        var tagFrom = tagNode.getParent()?.getParent();
        return tagFrom?.getAttributeValue(GlobalConstants.S_ID);
    }

    public getToKey(): string {
        return this.getTagNode().getAttributeValue(WfConstants.ATTR_TargetNodeKey);
    }

    public setFromNode(e:RectBound): void {
        this.fromEvent = e;
        this.drawLink();
    }

    public getFromNode(): AbstractNode | undefined {
        return this.fromNode;
    }

    public getToNode(): AbstractNode | undefined {
        return this.toNode;
    }

    public setToNode(e:RectBound): void {
      this.toEvent =e
        this.drawLink();
    }



    public hitHtmlElement(el: HTMLElement): boolean {
        return this.group.line.getHtmlElement() == el ||
            this.group.hide.getHtmlElement() == el ||
            this.group.triangle.getHtmlElement() == el ||
            this.getGCaption()?.getHtmlElement() == el;
    }

   /* setVisiable(b: boolean): void {
        this.group && this.group.line.setVisiable(b);
        this.group && this.group.triangle.setVisiable(b);
        this.group && this.group.fromHandler.setVisiable(b);
        this.group && this.group.toHandler.setVisiable(b);
    }
*/
    protected getNormalStrokeColor(): string {
        return this.normalStrokeColor;
    }

    public drawLink(): void {
        if (this.fromEvent && this.toEvent) {
            var pos = this.getPos(this.fromEvent, this.toEvent);
            this.group.hide.attr({"path": pos.linestr}).attr(this.arrowStyle).attr({stroke: this.getNormalStrokeColor()}).attr({'stroke-width': 6, 'stroke-opacity': '0.0'});
            this.group.line.attr({"path": pos.linestr}).attr(this.arrowStyle).attr({stroke: this.getNormalStrokeColor()});
            this.group.triangle.attr({"path": pos.trianglestr}).attr(this.arrowStyle);
            this.isSelected() ? this.markSelected() : this.markUnSelected();
            this.updateCaptionLoc();
        }
    }

    public getControlNode(): IGTable {
        return this.group.hide;
    }

    //private optSymbo?: IGElement;

    public markSelected(): void {
        this.markUnHovered();
        var selectStrokeColor = WfDefines.G_COLOR_STROKE_SELECT;
        var selectStrokeWidth = WfDefines.G_WIDTH_STROKE_SELECT;
        this.group.line && this.group.line.attr({'stroke': selectStrokeColor, 'strokeWidth': selectStrokeWidth});
        this.group.triangle && this.group.triangle.attr({'stroke': selectStrokeColor, 'strokeWidth': selectStrokeWidth, 'fill': selectStrokeColor});
        
        var selectAttr = {'fill': selectStrokeColor, 'stroke-opacity': '0.5'}
    }





    public markUnSelected(): void {
        if (!this.group) {
            return;
        }
        this.group.line && this.group.line.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth});
        this.group.triangle && this.group.triangle.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth, 'fill': this.getNormalStrokeColor()});
        var unSelectAttr = {'fill': 'none', 'stroke-opacity': '0.0'}
    }

    public markHovered(): void {
        if (this.isSelected()) return;
        var hoverStrokeColor = WfDefines.G_COLOR_STROKE_HOVER;
        var hoverStrokeWidth = WfDefines.G_WIDTH_STROKE_HOVER;
        this.group.line && this.group.line.attr({stroke: hoverStrokeColor, 'strokeWidth': hoverStrokeWidth});
        this.group.triangle && this.group.triangle.attr({stroke: hoverStrokeColor, 'strokeWidth': hoverStrokeWidth, 'fill': hoverStrokeColor});
    }

    public markUnHovered(): void {
        if (this.isSelected()) return;
        this.group.line && this.group.line.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth});
        this.group.triangle && this.group.triangle.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth, 'fill': this.getNormalStrokeColor()});
    }

    protected getPos(node1: RectBound, node2: RectBound): {x1:number, y1:number, x2: number, y2: number, linestr: string, trianglestr: string} {
        var conn = this.getConnection(node1 , node2),
            fromx = conn.x1,fromy = conn.y1,
            tox=conn.x2,toy = conn.y2,
            signX = (tox==fromx)? 1 : ((tox - fromx) / Math.abs(tox-fromx)),
            signY = (toy==fromy)? 1 : ((toy-fromy)/Math.abs(toy-fromy)),
            c = (tox==fromx) ? Math.PI / 2 : Math.abs(Math.atan((toy-fromy)/(tox-fromx))),
            triangleX1= (tox-Math.cos(c-Math.PI/12)*10*signX).toFixed(1),
            triangleY1= (toy-Math.sin(c-Math.PI/12)*10*signY).toFixed(1),
            triangleX2= (tox-Math.cos(c+Math.PI/12)*10*signX).toFixed(1),
            triangleY2= (toy-Math.sin(c+Math.PI/12)*10*signY).toFixed(1);
        return {
            x1: fromx, y1: fromy, x2: tox, y2: toy,
            linestr:"M"+fromx+","+fromy+" L"+tox+","+toy,
            trianglestr:"M"+tox+","+toy+" L"+triangleX1+","+triangleY1+" L"+triangleX2+","+triangleY2+" L"+tox+","+toy
        };
    }

                  
    private getConnection(bb1: RectBound, bb2: RectBound): {x1: number, y1: number, x2: number, y2: number} {
      //  var bb1 = obj1.getBounds(),
        //bb1 = obj2.getBounds(),
        var off1 = 0, 
            off2 = 0;
        var p = [
            /* NORTH 1 */
            { x: bb1.x + bb1.width / 2, y: bb1.y - off1 },
            /* SOUTH 1 */
            { x: bb1.x + bb1.width / 2, y: bb1.y + bb1.height + off1 },
            /* WEST */
            { x: bb1.x - off1, y: bb1.y + bb1.height / 2 },
            /* EAST  1 */
            { x: bb1.x + bb1.width + off1, y: bb1.y + bb1.height / 2 },
            /* NORTH 2 */
            { x: bb2.x + bb2.width / 2, y: bb2.y - off2 },
            /* SOUTH 2 */
            { x: bb2.x + bb2.width / 2, y: bb2.y + bb2.height + off2 },
            /* WEST  2 */
            { x: bb2.x - off2, y: bb2.y + bb2.height / 2 },
            /* EAST  2 */
            { x: bb2.x + bb2.width + off2, y: bb2.y + bb2.height / 2 }
        ];
        var d = new Map(), dis = [];
        for (var i = 0; i < 4; i++) {
            /* loop the seond object's connection coordinates */
            for (var j = 4; j < 8; j++) {
                var dx = Math.abs(p[i].x - p[j].x);
                var dy = Math.abs(p[i].y - p[j].y);
                if ((i == j - 4) || (((i != 3 && j != 6) || p[i].x < p[j].x)
                            && ((i != 2 && j != 7) || p[i].x > p[j].x)
                            && ((i != 0 && j != 5) || p[i].y > p[j].y)
                            && ((i != 1 && j != 4) || p[i].y < p[j].y))){
                                dis.push(dx + dy);
                                d.set(dis[dis.length - 1].toFixed(3), [i, j]); 
                                //d[dis[dis.length - 1].toFixed(3)] = [i, j];
                            }
            }
        }
        var res = dis.length == 0 ? [0, 4] : d.get(Math.min.apply(Math, dis).toFixed(3));
        return {x1:p[res[0]].x,y1: p[res[0]].y,x2:p[res[1]].x,y2:p[res[1]].y};
    }

    isDefaultCondition(): boolean {
        var condition = this.getCondition();
        return "TRUE" == condition.toUpperCase();
    }

    isDefaultCaption(): boolean {
        return this.getDefaultCaption() == this.getCaption();
    }

    getCondition(): string {
        return this.getTagNode().getAttributeValue(GlobalConstants.S_Condition, 'True');
    }

    getX(): number {
        return 0;
    }

    getY(): number {
        return 0;
    }


    ensureGraphicTagNode(): ITagNode {
        var xmlGraphicNode = this.xmlNode.getChild(WfConstants.NODE_TransitionGraphic);
        if (!xmlGraphicNode) {
            xmlGraphicNode = new TagNode(WfConstants.NODE_TransitionGraphic);
            this.xmlNode.addChild(xmlGraphicNode);
        } 
        return xmlGraphicNode;
    }
}