import AbstractOptState from "../../../common/state/AbstractOptState";
import DataMigrationGraphicView from "../view/DataMigrationGraphicView";
import DataMigrationOptStateDelegate from "./DataMigrationOptStateDelegate";
import ShadowLink from "../view/element/shadow/ShadowLink";
import {FieldView} from "../view/FieldView";
export default abstract class AbstactDataMigrationOptState extends AbstractOptState<DataMigrationGraphicView, DataMigrationOptStateDelegate> {



    protected shadowLink!: ShadowLink | undefined;


    constructor(optStateDelegate: DataMigrationOptStateDelegate) {
        super(optStateDelegate);
    }

    getViewEl(): HTMLElement {
        return this.getDelegate().getView().getTemplateView().getEl();
    }
    reset(): void {
        this.shadowLink?.remove();
        this.shadowLink = undefined;
        this.getDelegate().reset();
    }

    protected ensureShadowLink(): ShadowLink {
        if (this.shadowLink) return this.shadowLink;
        this.shadowLink = new ShadowLink();
        this.shadowLink.initGSection(this.getView().getPaper().section())
        return this.shadowLink;
    }

    findFieldView(e: MouseEvent): FieldView|undefined {
        var target = <HTMLElement>e.target;
        if(target.nodeName == "SPAN" || target.nodeName == "TD"){
            while (target.nodeName != "TR"){
                if (target.parentElement) {
                    target = target.parentElement;
                } else {
                    break;
                }
            }
        }
        let className = target.getAttribute("sourcetype");
        if (className == 'source') {
            this.getView().setSelectViewName("sourceColl");
        } else {
            this.getView().setSelectViewName("targetColl");
        }
        var {x, y} = this.getPosition(e);
        var view = <FieldView>this.getView().hitCell(x, y, className!);
        return view;
    }
}