import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import DataMigrationConstants from "../base/DataMigrationConstants";
import BaseConstants from "../../base/BaseConstants";
import XmlEntity from "../../../common/xml/XmlEntity";
import DataMigrationUtil from "../base/DataMigrationUtil";
import {CommonConstant} from "../../datamap/base/CommonConstant";


export default class NewLinkCmd implements ICmd {

    private formNode!: ITagNode;
    private parentFromNode?: ITagNode;

    private newTarNode?: ITagNode;
    private oldTarNode?: ITagNode;

    private xmlEntity: IXmlEntity;

    private tarNode!: ITagNode;


    constructor(xmlEntity: IXmlEntity, formNode: ITagNode, tarNode: ITagNode) {
        this.xmlEntity = xmlEntity;
        this.formNode = formNode;
        this.tarNode = tarNode;
    }

    do(): boolean {
        let targetNode = this.tarNode;
        let targetFieldKey = targetNode.getAttributeValue(DataMigrationConstants.NODE_FieldKey);
        let targetTableKey = targetNode.getParent()!.getAttributeValue(BaseConstants.ATTR_TableKey);
        let sourceNode = this.formNode;
        let find = sourceNode.getParent()!.find("SourceField", "TargetFieldKey", targetFieldKey);
        if (find) {
            if (find.getAttributeValue("TargetTableKey") != targetTableKey) {
                let node = sourceNode.toXml(true);
                this.oldTarNode = XmlEntity.parseTagNode(node);
                let type = sourceNode.getAttributeValue(DataMigrationConstants.Attr_Type,"");
                if (type != ""){
                    let parent = sourceNode.getParent();
                    if (parent!.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, targetFieldKey) != null) {
                        let i = 1;
                        while (parent!.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, targetFieldKey + i) != null) {
                            i++;
                        }
                        sourceNode.setAttributeValue(CommonConstant.S_Key, targetFieldKey + i);
                    } else {
                        sourceNode.setAttributeValue(CommonConstant.S_Key, targetFieldKey);
                    }
                }
                sourceNode.setAttributeValue(DataMigrationConstants.NODE_TargetTableKey, targetTableKey);
                sourceNode.setAttributeValue(DataMigrationConstants.NODE_TargetFieldKey, targetFieldKey);
                sourceNode.setAttributeValue("OpSign", "Assign");
                this.newTarNode = sourceNode;
                this.xmlEntity.update(sourceNode, true);
            }
        } else {
            let tar2 = sourceNode.getAttributeValue(DataMigrationConstants.NODE_TargetFieldKey);
            if (!tar2) {//已经存在节点
                let node = sourceNode.toXml(true);
                this.oldTarNode = XmlEntity.parseTagNode(node);
                let type = sourceNode.getAttributeValue(DataMigrationConstants.Attr_Type,"");
                if (type != ""){
                    let parent = sourceNode.getParent();
                    if (parent!.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, targetFieldKey) != null) {
                        let i = 1;
                        while (parent!.find(CommonConstant.NODE_SourceField, CommonConstant.S_Key, targetFieldKey + i) != null) {
                            i++;
                        }
                        sourceNode.setAttributeValue(CommonConstant.S_Key, targetFieldKey + i);
                    } else {
                        sourceNode.setAttributeValue(CommonConstant.S_Key, targetFieldKey);
                    }
                }
                sourceNode.setAttributeValue(DataMigrationConstants.NODE_TargetTableKey, targetTableKey);
                sourceNode.setAttributeValue(DataMigrationConstants.NODE_TargetFieldKey, targetFieldKey);
                sourceNode.setAttributeValue("OpSign", "Assign");
                this.newTarNode = sourceNode;
                this.xmlEntity.update(sourceNode, true);
            }else if(sourceNode.getAttributeValue(DataMigrationConstants.NODE_TargetFieldKey) == targetFieldKey
                && sourceNode.getAttributeValue(DataMigrationConstants.NODE_TargetTableKey) == targetTableKey){
                return true;
            }else{
                this.addSourceFieldValue(sourceNode, targetTableKey, targetFieldKey);
            }
        }
        return true;
    }

    addSourceFieldValue(sourceNode: ITagNode, targetTableKey: string, targetFieldKey: string ) {
        let parentNode = sourceNode.getParent()!;
        let newFieldNode = this.xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_SourceField);
        let newKey = DataMigrationUtil.getSourceFieldKey(sourceNode);
        newFieldNode.setAttributeValue(DataMigrationConstants.Attr_Key, newKey);
        newFieldNode.setAttributeValue(DataMigrationConstants.NODE_Definition, sourceNode.getAttributeValue(DataMigrationConstants.Attr_Key));
        if (sourceNode.getAttributeValue(DataMigrationConstants.Attr_Type)) {
            newFieldNode.setAttributeValue(DataMigrationConstants.Attr_Type, sourceNode.getAttributeValue(DataMigrationConstants.Attr_Type));
        }
        newFieldNode.setAttributeValue(DataMigrationConstants.NODE_TargetTableKey, targetTableKey);
        newFieldNode.setAttributeValue(DataMigrationConstants.NODE_TargetFieldKey, targetFieldKey);
        newFieldNode.setAttributeValue("OpSign", "Assign");
        parentNode.addChild(newFieldNode);
        this.parentFromNode = parentNode;
        this.newTarNode = newFieldNode;
        this.xmlEntity.update(parentNode, true);
    }

    undo(): void {
        if(!this.newTarNode) return;
        if(this.parentFromNode){
            this.parentFromNode.removeChild(this.newTarNode);
            this.xmlEntity.update(this.parentFromNode,true);
        }else {
            this.newTarNode.removeAttribute(DataMigrationConstants.NODE_TargetTableKey);
            this.newTarNode.removeAttribute(DataMigrationConstants.NODE_TargetFieldKey);
            this.newTarNode.removeAttribute("OpSign");
            this.xmlEntity.update(this.newTarNode, true);
        }
    }
}