import ICmd from "../../../common/cmd/ICmd";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";

export default class MoveFieldCmd implements ICmd {

    private formNode!: ITagNode;

    private xmlEntity: IXmlEntity;

    private tarNode!: ITagNode;

    constructor(xmlEntity: IXmlEntity, formNode:ITagNode,tarNode:ITagNode) {
        this.xmlEntity = xmlEntity;
        this.formNode = formNode;
        this.tarNode = tarNode;
    }

    do(): boolean {
        let parent = this.formNode.getParent()!;
        let children = parent.getChildren();
        //<SourceField Definition="LedgerID" OpSign="Assign" TargetFieldKey="LedgerID" TargetTableKey="EFI_VoucherBalance"/>
        let formNodeIndex = children.indexOf(this.formNode);
        let tarNodeIndex = children.indexOf(this.tarNode);
        [children[formNodeIndex], children[tarNodeIndex]] = [children[tarNodeIndex], children[formNodeIndex]]
        this.xmlEntity.update(parent, false);
        return true;
    }

    undo(): void {
        let parent = this.formNode.getParent()!;
        let children = parent.getChildren();
        let formNodeIndex = children.indexOf(this.formNode);
        let tarNodeIndex = children.indexOf(this.tarNode);
        [children[formNodeIndex], children[tarNodeIndex]] = [children[tarNodeIndex], children[formNodeIndex]]
        this.xmlEntity.update(parent, false);
    }

}