import ICmd from "../../../common/cmd/ICmd";
import DataMigrationGraphicView from "../view/DataMigrationGraphicView";
import ITagNode from "../../../common/xml/node/ITagNode";
import DataMigrationConstants from "../base/DataMigrationConstants";
import BaseConstants from "../../base/BaseConstants";


export default class AddTargetFieldCmd implements ICmd {




    private view: DataMigrationGraphicView;
    private tableKey: string;
    private newField: string;
    private tagNode: ITagNode;
    private  newTagNode?:ITagNode;



    constructor(view: DataMigrationGraphicView,tableKey :string,newField:string,tagNode:ITagNode) {
        this.view = view;
        this.tableKey = tableKey;
        this.newField = newField;
        this.tagNode = tagNode;


    }

    do(): boolean {
        var tableNode = this.tagNode;

        var xmlEntity = this.view.getXmlEntity();
        if (tableNode.getTagName() == DataMigrationConstants.NODE_TargetTableCollection){
            let targetTable = <ITagNode>tableNode.find(DataMigrationConstants.NODE_TargetTable,BaseConstants.ATTR_TableKey,this.tableKey);
            if (targetTable){
                let find = targetTable.find(DataMigrationConstants.NODE_TargetField,DataMigrationConstants.NODE_FieldKey,this.newField);
                if (find){
                    return  true;
                }
                var fieldNode = xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_TargetField);
                fieldNode.setAttributeValue(DataMigrationConstants.NODE_FieldKey,this.newField);
                targetTable.addChild(fieldNode);
                this.newTagNode = fieldNode;
            }else {
                var sourceNode = xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_TargetTable);
                sourceNode.setAttributeValue(BaseConstants.ATTR_TableKey,this.tableKey);
                tableNode.addChild(sourceNode)
                var fieldNode = xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_TargetField);
                fieldNode.setAttributeValue(DataMigrationConstants.NODE_FieldKey,this.newField);
                sourceNode.addChild(fieldNode);
                this.newTagNode = sourceNode;

            }
        }else {
            let find = tableNode.find(DataMigrationConstants.NODE_TargetField,DataMigrationConstants.NODE_FieldKey,this.newField);
            if (find){
                return  true;
            }
            var fieldNode = xmlEntity.getNodeFactory().createTagNode(DataMigrationConstants.NODE_TargetField);
            fieldNode.setAttributeValue(DataMigrationConstants.NODE_FieldKey,this.newField);
            tableNode.addChild(fieldNode);
            this.newTagNode = fieldNode;
        }
        xmlEntity.update(tableNode,true);
        return  true
    }





    undo(): void {
        if (this.newTagNode){
            this.view.getXmlEntity().removeNode(this.newTagNode);
        }
    }

}