import {AbstractElement} from "../../../base/AbstractElement";
import IGTable from "../../../../../common/ui/graphic/IGTable";
import ITagNode from "../../../../../common/xml/node/ITagNode";
import TagNode from "../../../../../common/xml/node/TagNode";
import {CommonConstant} from "../../../base/CommonConstant";
import RectBound from "../../../../../common/struct/RectBound";
import I18N from "../../../../bpm/base/I18N";
import MathUtil from "../../../../../common/util/MathUtil";
import {Point} from "../../../../../common/struct/Structs";
import AbstractNode from "../../../../bpm/view/element/node/AbstractNode";
import GlobalConstants from "../../../../../common/struct/GlobalConstants";


export abstract class Link extends AbstractElement{
    protected group!: {line: IGTable, hide: IGTable, triangle: IGTable,};
    protected normalStrokeColor: string = CommonConstant.G_COLOR_STROKE_NORMAL;
    private normalStrokeWidth:number = CommonConstant.G_WIDTH_STROKE_NORMAL;
    protected fromEvent?: RectBound;
    protected toEvent?: RectBound
    protected toNode?: AbstractNode;
    protected fromNode?: AbstractNode;
    private arrowStyle = {};
    private linkType!: number;

    public drawGraphic(): IGTable {
        this.group = {
            line: this.gSection.path(""),
            hide: this.gSection.path(""),
            triangle: this.gSection.path(""),
        };
        return this.group.line;
    }

    initGSection(section: IGTable): void {
        super.initGSection(section);
        this.dblClickHandler && this.getGCaption()?.dblclick(this.dblClickHandler)
    }

    ensureGraphicTagNode(): ITagNode {
        var xmlGraphicNode = this.xmlNode.getChild(CommonConstant.NODE_TransitionGraphic);
        if (!xmlGraphicNode) {
            xmlGraphicNode = new TagNode(CommonConstant.NODE_TransitionGraphic);
            this.xmlNode.addChild(xmlGraphicNode);
        }
        return xmlGraphicNode;
    }

    markSelected(): void {
        this.markUnHovered();
        let selectStrokeColor = CommonConstant.G_COLOR_STROKE_SELECT;
        let selectStrokeWidth = CommonConstant.G_WIDTH_STROKE_SELECT;
        if(this.linkType == CommonConstant.LinkType_Focus){
            selectStrokeColor = CommonConstant.G_COLOR_STROKE_SELECT;
            this.group.line && this.group.line.attr({'stroke': selectStrokeColor, 'strokeWidth': selectStrokeWidth,'stroke-dasharray': 4});
        }else if(this.linkType == CommonConstant.LinkType_SourceTypeKey){
            selectStrokeColor = CommonConstant.G_COLOR_STROKE_VEST;
            this.group.line && this.group.line.attr({'stroke': selectStrokeColor, 'strokeWidth': selectStrokeWidth});
        }else if(this.linkType == CommonConstant.LinkType_Focus_SourceTypeKey){
            selectStrokeColor = CommonConstant.G_COLOR_STROKE_VEST;
            this.group.line && this.group.line.attr({'stroke': selectStrokeColor, 'strokeWidth': selectStrokeWidth,'stroke-dasharray': 4});
        }else{
            this.group.line && this.group.line.attr({'stroke': selectStrokeColor, 'strokeWidth': selectStrokeWidth});
        }
        this.group.triangle && this.group.triangle.attr({'stroke': selectStrokeColor, 'strokeWidth': selectStrokeWidth, 'fill': selectStrokeColor});
    }

    markUnSelected(): void {
        if (!this.group) {
            return;
        }
        if(this.linkType == CommonConstant.LinkType_Focus || this.linkType == CommonConstant.LinkType_Focus_SourceTypeKey){
            this.group.line && this.group.line.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth, 'stroke-dasharray': 4});
        }else{
            this.group.line && this.group.line.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth});
        }
        this.group.triangle && this.group.triangle.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth, 'fill': this.getNormalStrokeColor()});
    }

    public markUnHovered(): void {
        if (this.isSelected()) return;
        if(this.linkType == CommonConstant.LinkType_Focus  || this.linkType == CommonConstant.LinkType_Focus_SourceTypeKey){
            this.group.line && this.group.line.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth, 'stroke-dasharray': 4});
        }else{
            this.group.line && this.group.line.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth});
        }
        this.group.triangle && this.group.triangle.attr({stroke: this.getNormalStrokeColor(), 'strokeWidth': this.normalStrokeWidth, 'fill': this.getNormalStrokeColor()});
    }

    protected getNormalStrokeColor(): string {
        if(this.linkType == CommonConstant.LinkType_SourceTypeKey || this.linkType  == CommonConstant.LinkType_Focus_SourceTypeKey) {
            return CommonConstant.G_COLOR_STROKE_VEST;
        }else if(this.linkType == CommonConstant.LinkType_Focus){
            return  CommonConstant.G_COLOR_STROKE_SELECT;
        }else {
            return this.normalStrokeColor;
        }
    }

    protected getPos(node1: RectBound, node2: RectBound): {x1:number, y1:number, x2: number, y2: number, linestr: string, trianglestr: string} {
        let conn = this.getConnection(node1 , node2),
            fromx = conn.x1,fromy = conn.y1,
            tox=conn.x2,toy = conn.y2,
            signX = (tox==fromx)? 1 : ((tox - fromx) / Math.abs(tox-fromx)),
            signY = (toy==fromy)? 1 : ((toy-fromy)/Math.abs(toy-fromy)),
            c = (tox==fromx) ? Math.PI / 2 : Math.abs(Math.atan((toy-fromy)/(tox-fromx))),
            triangleX1= (tox-Math.cos(c-Math.PI/12)*10*signX).toFixed(1),
            triangleY1= (toy-Math.sin(c-Math.PI/12)*10*signY).toFixed(1),
            triangleX2= (tox-Math.cos(c+Math.PI/12)*10*signX).toFixed(1),
            triangleY2= (toy-Math.sin(c+Math.PI/12)*10*signY).toFixed(1);
        return {
            x1: fromx, y1: fromy, x2: tox, y2: toy,
            linestr:"M"+fromx+","+fromy+" L"+tox+","+toy,
            trianglestr:"M"+tox+","+toy+" L"+triangleX1+","+triangleY1+" L"+triangleX2+","+triangleY2+" L"+tox+","+toy
        };
    }

    private getConnection(bb1: RectBound, bb2: RectBound): {x1: number, y1: number, x2: number, y2: number} {
        //  var bb1 = obj1.getBounds(),
        //bb1 = obj2.getBounds(),
        let off1 = 0,
            off2 = 0;
        let p = [
            /* NORTH 1 */
            { x: bb1.x + bb1.width / 2, y: bb1.y - off1 },
            /* SOUTH 1 */
            { x: bb1.x + bb1.width / 2, y: bb1.y + bb1.height + off1 },
            /* WEST */
            { x: bb1.x - off1, y: bb1.y + bb1.height / 2 },
            /* EAST  1 */
            { x: bb1.x + bb1.width + off1, y: bb1.y + bb1.height / 2 },
            /* NORTH 2 */
            { x: bb2.x + bb2.width / 2, y: bb2.y - off2 },
            /* SOUTH 2 */
            { x: bb2.x + bb2.width / 2, y: bb2.y + bb2.height + off2 },
            /* WEST  2 */
            { x: bb2.x - off2, y: bb2.y + bb2.height / 2 },
            /* EAST  2 */
            { x: bb2.x + bb2.width + off2, y: bb2.y + bb2.height / 2 }
        ];
        let d = new Map(), dis = [];
        for (let i = 0; i < 4; i++) {
            /* loop the seond object's connection coordinates */
            for (let j = 4; j < 8; j++) {
                let dx = Math.abs(p[i].x - p[j].x);
                let dy = Math.abs(p[i].y - p[j].y);
                if ((i == j - 4) || (((i != 3 && j != 6) || p[i].x < p[j].x)
                    && ((i != 2 && j != 7) || p[i].x > p[j].x)
                    && ((i != 0 && j != 5) || p[i].y > p[j].y)
                    && ((i != 1 && j != 4) || p[i].y < p[j].y))){
                    dis.push(dx + dy);
                    d.set(dis[dis.length - 1].toFixed(3), [i, j]);
                    //d[dis[dis.length - 1].toFixed(3)] = [i, j];
                }
            }
        }
        let res = dis.length == 0 ? [0, 4] : d.get(Math.min.apply(Math, dis).toFixed(3));
        return {x1:p[res[0]].x,y1: p[res[0]].y,x2:p[res[1]].x,y2:p[res[1]].y};
    }

    public setFromNode(e:RectBound,linkType: number): void {
        this.fromEvent = e;
        this.linkType = linkType;
        this.drawLink();
    }

    public drawLink(): void {
        if (this.fromEvent && this.toEvent) {
            let pos = this.getPos(this.fromEvent, this.toEvent);
            this.group.hide.attr({"path": pos.linestr}).attr(this.arrowStyle).attr({stroke: this.getNormalStrokeColor()}).attr({'stroke-width': 6, 'stroke-opacity': '0.0'});
            this.group.line.attr({"path": pos.linestr}).attr(this.arrowStyle).attr({stroke: this.getNormalStrokeColor()});
            this.group.triangle.attr({"path": pos.trianglestr}).attr(this.arrowStyle);
            this.isSelected() ? this.markSelected() : this.markUnSelected();
            this.updateCaptionLoc();
        }
    }

    updateCaptionLoc() {
        let center = this.getCenter();
        let gCaption = this.getGCaption();
        gCaption?.attr({x: center.x, y: center.y - 10});

        let bHideCaption = this.isNeedHideCaption();
        let showCaption = (!bHideCaption && this.isDefaultCaption()) ? this.getCondition() : this.getCaption();
        !bHideCaption && this.updateCaption(I18N.getString(showCaption));
        gCaption?.setVisiable(!bHideCaption);

        if (this.fromNode && this.toNode) {
            let pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
            let tan = MathUtil.tan(pos.x1, pos.y1, pos.x2, pos.y2);
            let d = Math.atan(tan) * 180/ Math.PI;

            if ((d >=0 && d<=45) ||
                (d >=135 && d <= 180)) {
                gCaption?.transform(d, center.x + 8, center.y - 8);
            } else {
                gCaption?.transform(d, center.x, center.y);
            }
        }
    }

    getCenter(): Point {
        let cx = 0, cy = 0;
        if (this.fromNode && this.toNode) {
            let pos = this.getPos(this.fromNode.getBounds(), this.toNode.getBounds());
            cx = (pos.x1 + pos.x2) / 2;
            cy = (pos.y1 + pos.y2) / 2;
        }
        return { x: cx, y: cy };
    }

    private isNeedHideCaption(): boolean {
        return this.isDefaultCaption() && this.isDefaultCondition();
    }

    isDefaultCaption(): boolean {
        return this.getDefaultCaption() == this.getCaption();
    }

    isDefaultCondition(): boolean {
        let condition = this.getCondition();
        return "TRUE" == condition.toUpperCase();
    }

    getCondition(): string {
        return this.getTagNode().getAttributeValue(GlobalConstants.S_Condition, 'True');
    }

    public setToNode(e:RectBound): void {
        this.toEvent =e
        this.drawLink();
    }

    public getControlNode(): IGTable {
        return this.group.hide;
    }



}