import JComponent from "../../../common/component/JComponent";
import {Container, DataMapTableLayout} from "../layout/DataMapTableLayout";
import ITagNode from "../../../common/xml/node/ITagNode";
import ArrayList from "../../../common/struct/ArrayList";
import {DataMapGraphicView} from "./DataMapGraphicView";
import {CommonConstant} from "../base/CommonConstant";
import Span from "../../../common/component/control/Span";
import TextEditor from "../../../common/component/control/TextEditor";
import InputElement from "../../../common/dom/element/InputElement";
import {FieldRow} from "./element/FieldRow";
import {CommonFunction} from "../base/CommonFunction";
import SizeInfo from "../../../common/struct/SizeInfo";
import Menu from "../../../common/component/menu/Menu";

export class DataMapFeedbackView extends JComponent<DataMapTableLayout>{
    private tagNode: ITagNode;
    private tableLayout: DataMapTableLayout;
    private icon: Span | undefined;
    private input: Span | undefined;
    private textEditor: TextEditor | undefined;
    private tableName: string | undefined;
    private addButton: InputElement | undefined;
    private menu: Menu = new Menu();

    // textEditor是否事件初始化
    private initTextEditor : boolean = false;

    constructor(tagNode: ITagNode, feedbackItem: Map<string, any>, index: number, dataMapGraphicView:DataMapGraphicView){
        super(new DataMapTableLayout(0,0));
        this.tagNode = tagNode;
        this.tableLayout = this.getDomElement();
        if(tagNode.getTagName() == CommonConstant.NODE_FeedbackTable){
            this.tableLayout.init(tagNode.getParent()!.getAttributeValueInt(CommonConstant.ATTR_Width, 0),CommonConstant.ROW_HEIGHT);
            this.buildTableRow(feedbackItem, dataMapGraphicView, index);
        }else if(tagNode.getTagName() == CommonConstant.NODE_FeedbackObject){
            this.tableLayout.init(tagNode.getAttributeValueInt(CommonConstant.ATTR_Width, 0) , CommonConstant.ROW_HEIGHT);
            this.buildFormRow(feedbackItem, index);
        }
        this.tableLayout.addClass('layout');

    }

    buildFormRow(feedbackItem: Map<string, any>, index: number){
        let field = this.tableLayout.addFeedbackField(CommonConstant.Type_Source_FeedBackTable, index);
        /*let parent = this.tagNode.getParent();
        if(!parent) return;*/
        let fieldView = new FieldRow(this.tagNode);
        field.addClass("tablehead");
        field.addChild(fieldView);

        let feedbackFormKey = this.tagNode.getAttributeValue(CommonConstant.ATTR_FormKey);
        this.tableName = feedbackFormKey;
        fieldView.buildFormRow(feedbackItem.get(feedbackFormKey),feedbackFormKey);
        let container = this.tableLayout.addSpan();
        this.addTitleComponent(container,CommonConstant.NODE_FormKey,feedbackFormKey);
    }

    buildTableRow(feedbackItem: Map<string, any> , dataMapGraphicView:DataMapGraphicView, index: number){
        let field = this.tableLayout.addFeedbackField(CommonConstant.Type_Source_FeedBackTable, index);
        let fieldRow = new FieldRow(this.tagNode);
        field.addChild(fieldRow);
        field.addClass("tablehead");

        let parent = this.tagNode.getParent()!;
        let feedbackFormKey = parent.getAttributeValue(CommonConstant.ATTR_FormKey);
        let tableKey = this.tagNode.getAttributeValue(CommonConstant.NODE_FeedbackTableKey);
        let caption = feedbackItem.get(tableKey) ? feedbackItem.get(tableKey).Caption : null;
        this.tableName = feedbackFormKey + "|" + tableKey;
        fieldRow.buildTableRow(tableKey, caption, dataMapGraphicView);

        let container = this.tableLayout.addSpan();
        this.addTitleComponent(container,CommonConstant.NODE_Table_Key,this.tableName);
        fieldRow.setText("(表" + feedbackItem.get(tableKey)?.index + ")  " + tableKey + " " + caption);
        fieldRow.addClass("tableRow");

        this.buildFieldRow(feedbackFormKey, tableKey, feedbackItem, dataMapGraphicView, index);
    }

    buildFieldRow(feedbackFormKey: string, tableKey: string, feedbackItem : Map<string, any>, dataMapGraphicView:DataMapGraphicView, index: number){
        let children = this.tagNode.getChildren();
        for (let child of children) {
            let caption = "";
            let dataType = "";
            let field = this.tableLayout.addFeedbackField(CommonConstant.Type_Source_FeedBackTable, index);
            let childTag = <ITagNode>child;
            let fieldKey = childTag.getAttributeValue(CommonConstant.NODE_FieldKey);
            let fieldRow = new FieldRow(childTag);
            field.addChild(fieldRow);
            if(feedbackItem.get(fieldKey)){
                caption = feedbackItem.get(fieldKey).Caption;
                dataType =  feedbackItem.get(fieldKey).DataType;
            }
            fieldRow.buildFieldRow(fieldKey, caption, dataType, dataMapGraphicView, "");
        }
    }

    addTitleComponent(container: Container,attrKey: string,attrValue: string){
        this.icon = container.getIcon();
        this.addButton = container.getAddButton();
        this.input = container.getInput();
        this.textEditor = container.getTextEditor();
        this.icon.getDomElement().setAttr(attrKey,attrValue);
        this.addButton.setAttr(attrKey,attrValue);
        this.input.getDomElement().setAttr(attrKey,attrValue);
    }

    isTableTitle(){
        return this.tagNode.getTagName() == CommonConstant.NODE_FeedbackObject;
    }

    setInitTextEditor(value : boolean) {
        this.initTextEditor = value;
    }

    getInitTextEditor(){
        return this.initTextEditor;
    }

    getAddIcon(){
        return this.icon!;
    }

    getInputButton(): InputElement{
        return this.addButton!;
    }

    getInputPromptSpan(){
        return this.input;
    }

    getInputTextEditor(){
        return this.textEditor;
    }

    getMenu(): Menu {
        this.menu.clearChildren();
        return this.menu;
    }


    getTableName(): string {
        return this.tableName!;
    }

    containPoint(x: number,y: number): boolean{
        return CommonFunction.containPoint(x,y,this.getEl());
    }

    getWidth(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableLayout.getWidth()!);
    }

    getHeight(): SizeInfo {
        return SizeInfo.valueOfPX(this.tableLayout.getHeight()!);
    }

    locRow(x: number, y: number): FieldRow | null{
        return CommonFunction.locRow(x, y, this.tableLayout);
    }

    getTagNode(): ITagNode {
        return this.tagNode;
    }
}