import {AbstractDataMapOptState} from "./AbstractDataMapOptState";
import {CommonConstant} from "../base/CommonConstant";
import {DataMapNewLinkState} from "./DataMapNewLinkState";
import {FieldRow} from "../view/element/FieldRow";
import {DataMapMoveTableState} from "./DataMapMoveTableState";
import {DataMapMoveFieldState} from "./DataMapMoveFieldState";
import SizeInfo from "../../../common/struct/SizeInfo";
import ITagNode from "../../../common/xml/node/ITagNode";

export class DataMapFieldOptState extends AbstractDataMapOptState{
    private el?: any;
    private view?: FieldRow;
    private startX = 0;
    private startY = 0;
    private fromTag?: FieldRow;
    private toNodeKey?: ITagNode;

    mousedown(e: MouseEvent): void {
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.el = e;
        let view = this.findFieldView(e);
        if (!view) return;
        let target = <HTMLElement> e.target;
        if(target.nodeName == CommonConstant.Node_Type_Span){
            target = <HTMLElement> target.parentElement;
        }
        let offsetWidth = target.offsetWidth;
        let offsetX = e.offsetX;
        this.MouseIcon(view, target, offsetX ,offsetWidth);

        let htmlElements = $(view.getEl());
        let attributeValue = view.getTagNode().getAttributeValue(CommonConstant.NODE_Type,CommonConstant.Type_Field);
        let tagNode = view.getTagNode();
        this.view = view;
        if(htmlElements.parent().hasClass("rowSelected") && htmlElements.parent().hasClass("dataMap_fieldCell_pointer")){
            this.editorFieldRow(attributeValue,this.view);
        }else{
            if((target.nodeName == CommonConstant.Node_Type_Button && target.className == "addFiledButton")
                || (target.nodeName == "IMG" && target.className == "map-delete-button-field")){
                this.getDelegate().setNormalState();
            }else{
                let selectionModel = this.getView().getXmlEntity().getSelectionModel();
                selectionModel.select(tagNode);
                this.getView().setSelectFieldView(view);
            }

        }

    }

    mousemove(e: MouseEvent): void {
        let el = <MouseEvent>this.el;
        let target = <HTMLElement>e.target;

        if(target.nodeName == CommonConstant.Node_Type_Span){
            target = <HTMLElement>target.parentElement;
        }

        let offsetWidth = target.offsetWidth;
        let offsetX = e.offsetX;
        let findFieldView = this.findFieldView(e);
        this.MouseIcon(findFieldView,target,offsetX,offsetWidth);
        if(e.button == 0 && e.buttons == 1 && this.view){ //按下并且移动
            if(findFieldView){ //在table内
                this.onTable(e,el, findFieldView, this.view);
            }else{ //在table外
                this.outTable(el,this.view);
            }
        }else{//普通的移动
            if(!findFieldView){
                this.getDelegate().setNormalState();
            }
        }

    }



    onTable(e: MouseEvent, el: MouseEvent,findFieldView: FieldRow, view: FieldRow){
        if(Math.abs(this.startX - e.clientX) > 1 || Math.abs(this.startY - e.clientY) > 1){
            findFieldView.getDeleteButton()?.setStyle("display","none");
        }
        //拖动的是头
        let tagName = findFieldView.getTagNode().getTagName();
        if( (tagName == CommonConstant.NODE_SourceTableCollection || tagName == CommonConstant.NODE_TargetTableCollection || tagName == CommonConstant.NODE_FeedbackObject)
            && (Math.abs(this.startX - e.clientX) > 10 || Math.abs(this.startY - e.clientY) > 10)
            && findFieldView.getTagNode() == view.getTagNode()){
            let dataMapMoveTableState = new DataMapMoveTableState(this.getDelegate());
            dataMapMoveTableState.init(findFieldView,el,true);
            this.getDelegate().setMoveTableState(dataMapMoveTableState);
        }else if(findFieldView.getTagNode() != view.getTagNode()){ //拖动离开了字段
            //改变鼠标样式
            let dataMapMoveFieldState = new DataMapMoveFieldState(this.getDelegate());
            dataMapMoveFieldState.setFromEl(view);
            this.getDelegate().setMoveFieldState(dataMapMoveFieldState);
        }

    }

    outTable(el: MouseEvent, view : FieldRow){
        let dataMapNewLinkState = new DataMapNewLinkState(this.getDelegate());
        dataMapNewLinkState.setFromEl(view, el);
        this.getDelegate().setNewLinkState(dataMapNewLinkState);
        this.el = undefined;
        this.view = undefined;
    }

    MouseIcon(findFieldView:  FieldRow | undefined , target: HTMLElement, offsetX: number, offsetWidth: number) {
        if (!findFieldView || (findFieldView.getTagNode().getTagName() != CommonConstant.NODE_SourceField
        && findFieldView.getTagNode().getTagName() != CommonConstant.NODE_TargetField )) return;
        const el = $(target);
        el.removeClass("dataMap_fieldCell_move");
        el.removeClass("dataMap_fieldCell_crosshair");
        el.removeClass("dataMap_fieldCell_pointer");

        if (target.nodeName != CommonConstant.Node_Type_Td || el.hasClass("tablehead")) return;
        let attributeValue = findFieldView.getTagNode().getAttributeValue(CommonConstant.NODE_Type, CommonConstant.Type_Field);
        //计算出删除按钮的位置
        if(offsetX < offsetWidth && offsetX > offsetWidth - 30){
            //el.addClass("dataMap_fieldCell_crosshair");
        }else {
            let parentTagNode = findFieldView.getTagNode().getParent();
            if (parentTagNode?.getTagName() == CommonConstant.NODE_SourceTable &&
                (parentTagNode.getAttributeValue(CommonConstant.ATTR_Type) == CommonConstant.SERVICE || this.getView().getServiceSourceTable().indexOf(parentTagNode.getAttributeValue(CommonConstant.S_Key)) > -1)) {
                el.addClass("dataMap_fieldCell_pointer");
            } else {
                if (attributeValue != CommonConstant.Type_Field) {
                    el.addClass("dataMap_fieldCell_pointer");
                } else {
                    el.addClass("dataMap_fieldCell_move");
                }
            }
        }

    }

    editorFieldRow(attributeValue: string, view: FieldRow){
        let htmlElements = $(view.getEl());
        view.setStyle("display", "none");
        let height = SizeInfo.valueOfPX(Number(htmlElements.parent().height()));
        let width = SizeInfo.valueOfPX(Number(htmlElements.parent().width()));
        //支持修改
        let textEditor = view.getTextEditor();
        textEditor.setStyle("display", "block");
        view.getDeleteButton().setStyle("display", "none");
        textEditor.setStyle("width", width);
        textEditor.setStyle("height", "100%");
        textEditor.setStyle("min-height", height);
        textEditor.setStyle("disabled", "true");
        setTimeout(function () {
            let text = view!.getCaption();
            textEditor.setValue(text);
            textEditor.getEl().focus();
        }, 10);
    }

    mouseup(e: MouseEvent): void {
        this.el = undefined;
        this.view = undefined;
        this.getDelegate().setNormalState();
    }

    reset(): void {
        this.fromTag = undefined;
        this.toNodeKey = undefined;
        this.getDelegate().reset();
    }
}