import ICmd from "../../../common/cmd/ICmd";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import XmlEntity from "../../../common/xml/XmlEntity";
import {CommonConstant} from "../base/CommonConstant";

export class MoveDataMapTableCmd implements ICmd{
    private x: number;
    private y: number;
    private tagNode: ITagNode;
    private newTagNode?: ITagNode;
    private oldTagNode?: ITagNode;
    private xmlEntity: IXmlEntity;

    constructor(xmlEntity: IXmlEntity, tagNode: ITagNode, x: number, y: number){
        this.xmlEntity = xmlEntity;
        this.tagNode = tagNode;
        this.x = x;
        this.y = y;
    }

    do(): boolean {
        let formRowTagNode = this.tagNode;
        let xml = formRowTagNode.toXml(true);
        this.oldTagNode = XmlEntity.parseTagNode(xml);
        formRowTagNode.setAttributeValue(CommonConstant.ATTR_X, String(this.x));
        formRowTagNode.setAttributeValue(CommonConstant.ATTR_Y, String(this.y));
        this.newTagNode = formRowTagNode;
        this.xmlEntity.update(formRowTagNode,true);
        return true;
    }

    undo(): void {
        if(!this.newTagNode) return;
        this.newTagNode.setAttributeValue(CommonConstant.ATTR_X, this.oldTagNode!.getAttributeValue(CommonConstant.ATTR_X),String(this.x));
        this.newTagNode.setAttributeValue(CommonConstant.ATTR_Y, this.oldTagNode!.getAttributeValue(CommonConstant.ATTR_Y),String(this.y));
        this.xmlEntity.update(this.newTagNode,true);
    }

}