import ICmd from "../../../common/cmd/ICmd";
import ITagNode from "../../../common/xml/node/ITagNode";
import {DataMapGraphicView} from "../view/DataMapGraphicView";
import {CommonConstant} from "../base/CommonConstant";
import IXmlEntity from "../../../common/xml/IXmlEntity";

export class AddTargetFieldCmd implements ICmd {
    private dataMapGraphicView: DataMapGraphicView;
    private tableKey: string;
    private newField: string;
    private tagNode: ITagNode;
    private newTagNode?: ITagNode;

    constructor(dataMapGraphicView: DataMapGraphicView, tableKey: string, fieldKey: string, tagNode: ITagNode){
        this.dataMapGraphicView = dataMapGraphicView;
        this.tableKey = tableKey;
        this.newField = fieldKey;
        this.tagNode = tagNode;
    }

    do(): boolean {
        let tagNode = this.tagNode;
        let xmlEntity = this.dataMapGraphicView.getXmlEntity();
        if(tagNode.getTagName() == CommonConstant.NODE_TargetTableCollection){
            let sourceTable = <ITagNode>tagNode.find(CommonConstant.NODE_TargetTable, CommonConstant.NODE_Table_Key, this.tableKey);
            if(sourceTable){
                this.addSourceField(sourceTable,xmlEntity);
            }else{
                let newTableTagNode = xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_TargetTable);
                newTableTagNode.setAttributeValue(CommonConstant.NODE_Table_Key, this.tableKey);
                //newTableTagNode.setAttributeValue(CommonConstant.NODE_Type, "Table");
                //newTableTagNode.setAttributeValue(CommonConstant.ATTR_DataSource, this.tableKey);
                tagNode.addChild(newTableTagNode);
                let newTagNode = xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_TargetField);
                newTagNode.setAttributeValue(CommonConstant.NODE_Definition, this.newField);
                newTableTagNode.addChild(newTagNode);
                this.newTagNode = newTableTagNode;
            }
        }else{
            this.addSourceField(tagNode, xmlEntity);
        }
        xmlEntity.update(tagNode,true);
        return true;
    }

    addSourceField(tagNode: ITagNode, xmlEntity: IXmlEntity){
        if(tagNode.find(CommonConstant.NODE_TargetField, CommonConstant.NODE_Definition, this.newField)) return true;
        let newTagNode = xmlEntity.getNodeFactory().createTagNode(CommonConstant.NODE_TargetField);
        newTagNode.setAttributeValue(CommonConstant.NODE_Definition, this.newField);
        tagNode.addChild(newTagNode);
        this.newTagNode = newTagNode;
    }

    undo(): void {
        if (this.newTagNode) {
            this.dataMapGraphicView.getXmlEntity().removeNode(this.newTagNode);
        }
    }

}