import IXmlEntity from "../../../../common/xml/IXmlEntity";
import ITagNode from "../../../../common/xml/node/ITagNode";
import WfConstants from "../../base/WfConstants";
import AbstractLink from "../element/link/AbstractLink";
import AbstractNode from "../element/node/AbstractNode";
import WfGraphicView from "../WfGraphicView";
import FormatNode from "./FormatNode";

export default class WfFormator {

    private static X_STEP = 100;

    private static Y_STEP = 100;

    private view: WfGraphicView;

    private mapFormatNodes: Map<String, FormatNode> = new Map();

    constructor(view: WfGraphicView) {
        this.view = view;
    }

    format(view: WfGraphicView): void {
        this.prepareFormatNodes(view);

        var beginNode = view.getBeginNode();
        var endNode = view.getEndNode();
        if (!beginNode || !endNode) return;

        var beginFormatNode = this.getFormatNode(beginNode.getID());
        if (!beginFormatNode) return;

        var endFormatNode = this.getFormatNode(endNode.getID());
        if (!endFormatNode) return;
    }

    private mapForwordedNodes: Map<String, FormatNode> = new Map();

    private forwordNodes(node: AbstractNode | undefined): FormatNode | undefined {
        if (!node) return;
        var formatNode = this.ensureFormatNode(node);
        this.mapForwordedNodes.set(node.getID(), formatNode)
        var links = this.view.getLinks();
        for (let link of links) {
            var fromNode = link.getFromNode();
            var toNode = link.getToNode();
            var toNodeID = toNode?.getID();
            if (!toNode || !toNodeID) continue;
            if (fromNode == node && !this.mapForwordedNodes.has(toNodeID)) {
                var child = this.ensureFormatNode(toNode);
                formatNode.addChildNode(child);
                this.forwordNodes(toNode)
            }
        }
        return formatNode;
    }

    private getFormatNode(id: string): FormatNode | undefined {
        return this.mapFormatNodes.get(id);
    }

    private prepareFormatNodes(view: WfGraphicView) {
        var links = view.getLinks();
        for (let link of links) {
            var fromViewNode = link.getFromNode();
            if (fromViewNode) {
                var formatNode = this.ensureFormatNode(fromViewNode);
                formatNode.addOutLink(link);
            }
            var toViewNode = link.getToNode();
            if (toViewNode) {
                var formatNode = this.ensureFormatNode(toViewNode);
                formatNode.addInLink(link);
            }
        }
    }

    private ensureFormatNode(viewNode: AbstractNode): FormatNode {
        var id = viewNode.getID();
        var formatNode = this.mapFormatNodes.get(id);
        if (!formatNode) {
            formatNode = new FormatNode(viewNode);
            this.mapFormatNodes.set(id, formatNode)
        }
        return formatNode;
    }
    /**
     * 获取前进流
     */
    private getFlows(tagNode: ITagNode): ITagNode[] {
        var node = tagNode.getChild(WfConstants.NODE_TransitionCollection);
        return <ITagNode[]> node?.getChildren();
    }
}