import AbstractLink from "../element/link/AbstractLink";
import AbstractNode from "../element/node/AbstractNode";

export default class FormatNode {

    private viewNode: AbstractNode;

    private inLinks: AbstractLink[] = [];

    private outLinks: AbstractLink[] = [];

    private children: FormatNode[] = [];

    private parent?: FormatNode;

    constructor(viewNode: AbstractNode) {
        this.viewNode = viewNode;
    }

    getViewNode(): AbstractNode {
        return this.viewNode;
    }

    setParent(parent: FormatNode): void {
        this.parent = parent;
    }

    getParent(): FormatNode | undefined {
        return this.parent;
    }

    addChildNode(child: FormatNode) {
        this.children.push(child);
        child.setParent(this);
    }

    addInLink(inLink: AbstractLink): void {
        this.inLinks.push(inLink);
    }

    addOutLink(outLink: AbstractLink): void {
        this.outLinks.push(outLink);
    }

    getInLinks(): AbstractLink[] {
        return this.inLinks;
    }

    getOutLinks(): AbstractLink[] {
        return this.outLinks;
    }
}