import ITagNode from "../../../../../../common/xml/node/ITagNode";
import WfConstants from "../../../../base/WfConstants";
import AbstractWfElement from "../../AbstractWfElement";
import BaseDiamondNode from "./BaseDiamondNode";

export default class DecisionNode extends BaseDiamondNode {

    constructor(xmlNode?: ITagNode) {
        super(xmlNode);
    }

    protected drawSymbo(): void{
        var w = this.getBounds().width,
            h = this.getBounds().height;
        this.gSection.text(w / 2, h / 2 + 5, '?')
            .attr({'text-anchor': 'middle', 'font-weight': 'bold', 'font-size': 20});
    }

    public getType(): string {
        return WfConstants.NODE_Gateway_Decision;
    }

    public newInstance(xmlNode: ITagNode): AbstractWfElement {
        return new DecisionNode(xmlNode);
    }
}