import IXElement from "../../../common/dom/xelement/IXElement";
import AbstractOptState from "../../../common/state/AbstractOptState";
import WfGraphicView from "../view/WfGraphicView";
import OptStateDelegate from "./OptStateDelegate";
import ShadowLink from "./shadow/ShadowLink";

export default abstract class AbstractWfOptState extends AbstractOptState<WfGraphicView, OptStateDelegate> {

    private type: string = "";

    protected view: WfGraphicView;

    protected shadowLink!: ShadowLink | undefined;

    constructor(view: WfGraphicView, delegate: OptStateDelegate) {
        super(delegate);
        this.view = view;
    }

    getViewEl(): HTMLElement {
        return this.view.getEl();
    }

    getView(): WfGraphicView {
        return this.view;
    }

    setType(type: string) {
        this.type = type;
    }

    getType() {
        return this.type;
    }

    reset(): void {
        this.shadowLink?.remove();
        this.shadowLink = undefined;
        this.getDelegate().reset();
    }

    protected ensureShadowLink(): ShadowLink {
        if (this.shadowLink) return this.shadowLink;
        this.shadowLink = new ShadowLink();
        this.shadowLink.initGSection(this.view.getPaper().section())
        return this.shadowLink;
    }
}