import IEventListener from "../../../../common/listener/IEventListener";
import Paras from "../../../../common/struct/Paras";
import Events from "../../../../common/event/Events";
import IPropertyItem, { IPropertyGroup, IPropertyIO } from "../../../plugin/property/base/PropertyDefine";
import JTabbedPane from "../../../../common/component/tab/JTabbedPane";
import BasePropertyView from "./view/BasePropertyView";
import ParticipatorPropertyView from "./view/ParticipatorPropertyView";
import IView from "../../../../common/interfaces/IView";
import SizeInfo from "../../../../common/struct/SizeInfo";
import Tab from "../../../../common/component/tab/Tab";
import OperationPropertyView from "./view/OperationPropertyView";
import WfConstants from "../../base/WfConstants";
import OperationDispatcher from "../../../../common/operation/OperationDispatcher";
import IXElement from "../../../../common/dom/xelement/IXElement";

export default class BPMPropertyUIPanel extends JTabbedPane implements IEventListener {

    private tabBase?: Tab;
    private tabParticipator?: Tab;
    private tabOperation?: Tab;
    //private tabPerm?: Tab;
    private operationDispatcher: OperationDispatcher;

    private basePropertyView?: BasePropertyView;

    constructor(operationDispatcher: OperationDispatcher) {
        super();
        this.operationDispatcher = operationDispatcher;
        this.addClassArray(this.styleFactory.getPropertyPanel());
    }

    loadProperty(groups: IPropertyGroup[], callback: IPropertyIO) {
        this.tabBase = this.addTab("Base", "基础");
        this.basePropertyView = new BasePropertyView(groups, callback, this.operationDispatcher);
        var view: IView = this.basePropertyView;
        this.tabBase.setView(view);

        var propertyItem = this.getPropertyItem(WfConstants.NODE_ParticipatorCollection, groups);
        if (propertyItem) {
            this.tabParticipator = this.addTab("Participator", "参与者");
            var viewParticipator: ParticipatorPropertyView = new ParticipatorPropertyView(this.operationDispatcher, propertyItem, callback);
            //viewParticipator.loadProperty(propertyItem, callback);
            this.tabParticipator.setView(viewParticipator);
        }

        propertyItem = this.getPropertyItem(WfConstants.NODE_OperationCollection, groups);
        if (propertyItem) {
            this.tabOperation = this.addTab("Operation", "操作项");
            var viewOperation = new OperationPropertyView(this.operationDispatcher, propertyItem, callback);
            //viewOperation.loadProperty(propertyItem, callback);
            this.tabOperation.setView(viewOperation);
        }
        this.select(0);
    }

    setPropertyValue(key: string, value: any, text?: string): void {
        this.basePropertyView?.setPropertyValue(key, value, text);
    }

    setFocus(key: string): void {
        this.basePropertyView?.setFocus(key);
    }

    private getPropertyItem(key: string, groups: IPropertyGroup[]): IPropertyItem | undefined {
        if (groups) {
            for (let group of groups) {
                for (let item of group.properties) {
                    if (item.key == key) {
                        return item;
                    }
                }
            }
        }
        return undefined;
    }

    notifyEvent(cmd: string, paras: Paras): void {
        switch (cmd) {
            case Events.Focus:
                this.focus(paras.getElement());
                break;
        }
    }

    focus(el: IXElement): void {
        this.tabBase?.getView().focus(el);
    }

    unfocus(): void {
        this.tabBase?.getView().unfocus();
    }

    display(width?: SizeInfo, height?: SizeInfo): void {
        this.tabBase?.getView().display(this.tabBase.getContent(), width, height);
        //this.tabParticipator?.getView().display(this.tabParticipator.getContent(), width, height);
        //this.tabOperation?.getView().display(this.tabOperation.getContent(), width, height);
        //this.tabPerm?.getView().display(this.tabPerm.getContent(), width, height);
    }

    resize(width:number, height:number) {
        var widthInfo = SizeInfo.valueOfPX(width - 5);
        var heightInfo = SizeInfo.valueOfPX(height - 40 - 5);
        this.tabBase?.getView().resize(widthInfo, heightInfo);
        this.tabParticipator?.getView().resize(widthInfo, heightInfo);
        this.tabOperation?.getView().resize(widthInfo, heightInfo);
        //this.tabPerm?.getView().resize(widthInfo, heightInfo);
    }
}
