import ICmd from "../../../common/cmd/ICmd";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import WfNodeUtil from "../util/WfNodeUtil";

export default class NewNodeCmd implements ICmd {

    private x: number = 0;

    private y: number = 0;

    private id: string;

    private type: string;

    private tagNode?: ITagNode;

    private xmlEntity: IXmlEntity;

    constructor(xmlEntity: IXmlEntity, id: number, type: string, x: number, y: number) {
        this.xmlEntity = xmlEntity;
        this.id = String(id);
        this.type = type;
        this.x = Math.ceil(x);
        this.y = Math.ceil(y);
    }

    do(): boolean {
        this.tagNode = WfNodeUtil.createNode(this.xmlEntity, this.id, this.type, this.x, this.y);
        this.xmlEntity.addNode(this.tagNode);
        return true;
    }

    undo(): void {
        this.tagNode && this.xmlEntity.removeNode(this.tagNode);
    }

}