import ICmd from "../../../common/cmd/ICmd";
import IXmlEntity from "../../../common/xml/IXmlEntity";
import ITagNode from "../../../common/xml/node/ITagNode";
import WfConstants from "../base/WfConstants";
import AbstractWfElement from "../view/element/AbstractWfElement";
import AbstractLink from "../view/element/link/AbstractLink";

export default class ChangeLineToNodeCmd implements ICmd {

    private orgToNode?: AbstractWfElement;

    //private view: WfGraphicView;

    private link?: AbstractLink;

    private toNode?: AbstractWfElement;

    private xmlEntity: IXmlEntity;

    private linkTag: ITagNode;

    private toKey: string;

    private orgToKey: string = "";

    constructor(xmlEntity: IXmlEntity, linkTag: ITagNode, toKey: string) {
        this.xmlEntity = xmlEntity;
        this.linkTag = linkTag;
        this.toKey = toKey;
    }

    do(): boolean {
        this.orgToKey = this.linkTag.getAttributeValue(WfConstants.ATTR_TargetNodeKey);
        this.linkTag.setAttributeValue(WfConstants.ATTR_TargetNodeKey, this.toKey);
        this.xmlEntity.update(this.linkTag, false);
        return true;
    }

    undo(): void {
        this.linkTag.setAttributeValue(WfConstants.ATTR_TargetNodeKey, this.orgToKey);
        this.xmlEntity.update(this.linkTag, false);
    }
}