import DevDesignView from "./view/DevDesignView";
import UserDesignView from "./view/UserDesignView";
import ComplexDesignView from "../base/ComplexDesignView";
import GlobalVariable from '../GlobalVariable';
import { EDesignMode } from '../../common/enum/Enums';
import SelectionModel from '../../common/selection/SelectionModel';
import WfGraphicView from './view/WfGraphicView';
import ISaveListener from '../../common/interfaces/IOptActionListener';
import GlobalConstants from '../../common/struct/GlobalConstants';
import AbstractWorkSpace from '../base/AbstractWorkSpace';
import AbstractDesignView from '../base/AbstractDesignView';
import WfToolbox from "./view/WfToolbox";
import Toolbar from "../../common/component/toolbar/Toolbar";
import Button from "../../common/component/control/Button";
import Checkbox from "../../common/component/control/Checkbox";
import AbstractControl from "../../common/component/control/AbstractControl";
import OperationDispatcher from "../../common/operation/OperationDispatcher";

export default class BPMNWorkSpace extends AbstractWorkSpace<WfGraphicView, Toolbar> implements ISaveListener {

    constructor(mode: EDesignMode) {
        super(mode, new Toolbar());
        this.addClass("bpm-workspace");
        this.addClassArray(this.styleFactory.getBpmWorkspace());
    }

    createDesignView(viewContainer: ComplexDesignView<WfGraphicView, Toolbar>, operationDispatcher: OperationDispatcher): AbstractDesignView<any> {
        return this.isUserModel() ? new UserDesignView(viewContainer, this.operationDispatcher) : new DevDesignView(viewContainer, operationDispatcher);
    }

    createGraphicView(mode: EDesignMode): WfGraphicView {
        var toolbox =  (mode == EDesignMode.Dev || mode == EDesignMode.Local ? new WfToolbox() : undefined);
        return new WfGraphicView(toolbox);
    }

    delete(): void {
        var exp = `DeleteBpm()`;
        this.operationDispatcher.eval(exp);
    }

    newVer(): void {
        var exp = `NewBpmVersion()`;
        this.operationDispatcher.eval(exp);
    }

    deploy(): void {
        var exp = `DeployBpm()`;
        this.operationDispatcher.eval(exp);
    }

    save(): void {
        var exp = `SaveBpm()`;
        this.operationDispatcher.eval(exp);
    }

    getSelectionModel(): SelectionModel {
        return this.getXmlEntity() && this.getXmlEntity().getSelectionModel();
    }

    load(xml: string) {
        super.load(xml ? xml : GlobalConstants.XML_WF_DEFAULT)
    }

    deleteElement(): void {
        this.viewContainer.getGraphicView().doDeleteElementCmd();
    }

    protected prepareToolbar(toolbar: Toolbar): void {
        if (this.getMode() == EDesignMode.Local) {
            var btnNewVer = new Button("新增版本");
            btnNewVer.setOnClickListener((e: MouseEvent) => {
                this.newVer()
            });
            toolbar.addItem(btnNewVer);

            var btnSave = new Button("保存");
            btnSave.setOnClickListener((e: MouseEvent) => {
                this.save();
            });
            toolbar.addItem(btnSave);

            var btnDelete = new Button("删除");
            btnDelete.setOnClickListener((e: MouseEvent) => {
                this.delete();
            });
            toolbar.addItem(btnDelete);

            var btnDeploy = new Button("部署");
            btnDeploy.setOnClickListener((e: MouseEvent) => {
                this.deploy();
            });
            toolbar.addItem(btnDeploy);
        }

        this.viewContainer.installToolbar(toolbar, this.getMode());

        toolbar.addSeparator();
        var chkShowSeq = new Checkbox("显示顺序流");
        chkShowSeq.setChecked(true);
        chkShowSeq.setOnValueChanged((control: AbstractControl<any>) => {
            var check = <Checkbox> control;
            this.viewContainer.getGraphicView().setSequenceFlowDisplay(check.isChecked());
        });
        toolbar.addItem(chkShowSeq);

        var chkShowDeny = new Checkbox("显示驳回流");
        chkShowDeny.setOnValueChanged((control: AbstractControl<any>) => {
            var check = <Checkbox> control;
            this.viewContainer.getGraphicView().setDenyFlowDisplay(check.isChecked());
        });
        toolbar.addItem(chkShowDeny);
    }
}