import GlobalVariable from "../GlobalVariable";

export default class RunDictFormula {

    private code: string;

    constructor(code: string) {
        this.code = code;
    }

    getCode(): string {
        return this.code;
    }

    getDictKey(): string {
        return GlobalVariable.G_FORMULA_DICT;
    }

    toString(): string {
        return `${GlobalVariable.G_RUN_DICTFORMULA}('${this.code}')`;
    }

    static isRunDictFormula(str: string): boolean {
        if (!str) return false;
        str = str.trim();
        return str.startsWith(GlobalVariable.G_RUN_DICTFORMULA);
    }

    static parse(strFormula: string): RunDictFormula | undefined {
        if (RunDictFormula.isRunDictFormula(strFormula)) {
            var start = strFormula.indexOf('\'');
            var sub1 = strFormula.substring(start + 1, strFormula.length - 1);
            var end = sub1.indexOf('\'');
            var code = sub1.substring(0, end);
            return new RunDictFormula(code);
        }
        return undefined;
    }

    static parseToRunDictFormulaStr(code: string): string {
        return `RunDictFormula('${code}')`;
    }

}