import BorderPanel from "../../common/component/container/panel/BorderPanel";
import { IPropertyContainer, IPropertyPlugin } from "../plugin/property/base/PropertyDefine";
import PropertyUIContainer from "../plugin/property/ui/PropertyUIContainer";

export default class AbstractDesignView<T extends IPropertyPlugin> extends BorderPanel implements IPropertyContainer<T> {

    protected propertyUIContainer: PropertyUIContainer<T>;

    constructor(propertyWidth: number, propertyUIContainer: PropertyUIContainer<T>) {
        super(0, propertyWidth, 0 , 0);
        this.propertyUIContainer = propertyUIContainer;
    }

    getPropertyUIContainer(): PropertyUIContainer<T> {
        return this.propertyUIContainer;
    }
}