export default class GlobalVariable {

    static G_FORMULA_DICT: string = 'FormulaDefine';

    static G_RUN_DICTFORMULA: string = 'RunDictFormula';

    static G_DevelopCode: string = '000';

    static isInIFrame(): boolean {
        return window.DesignEnv == 'IFrame';
    }

    public static EMPTY_WORKFLOW = `<?xml version="1.0" encoding="UTF-8" standalone="no"?>
    <Process>
        <Begin ID="1" Key="Begin" Caption="起始">
            <NodeGraphic X="303" Y="131"/>
            <TransitionCollection>
                <SequenceFlow ID="3" Key="SequenceFlow" Caption="顺序流" TargetNodeKey="End"/>
            </TransitionCollection>
        </Begin>
        <End ID="2" Key="End" Caption="结束">
            <NodeGraphic X="303" Y="597"/>
        </End>
    </Process>`;

    public static V_LIST_BOOLEAN: string = "{list.boolean}";
    public static V_LIST_STATUS: string = "{list.status}";
    public static V_INPUT_IMAGE: string = "{input.image}";
    public static V_BPMN_INPUT_PERM: string = "{bpmn.input.perm}";
    public static V_BPMN_INPUT_FORMULA: string = "{bpmn.input.formula}";
    public static V_BPMN_LIST_STATE: string = "{bpmn.list.state}";
    public static V_BPMN_LIST_SUBPROCESS: string = "{bpmn.list.subprocess}";

    public static V_BPMN_COUNTERSIGN_CONDITION_TYPE: string = "{bpmn.countersign.condition.type}";
    public static V_BPMN_INPUT_TIMERITEM_C: string = "{bpmn.input.timeritem.collection}";
    public static V_BPMN_INPUT_OPERATION_C: string = "{bpmn.input.operation.collection}";
    public static V_BPMN_INPUT_ASSISTANCE_C: string = "{bpmn.input.assistance.collection}";
    public static V_BPMN_INPUT_PARTICIPATOR_C: string = "{bpmn.input.participator.collection}";

    public static V_SELF_VALUE: string = "{self.value}";
    public static V_SELF_KEY: string = "{self.key}";

    
    private static mapVariables: Map<string, any> = new Map([
        [GlobalVariable.V_LIST_BOOLEAN, [{text: "是", value: "true"},{text: "否", value: "false"}]],
        [GlobalVariable.V_LIST_STATUS, [{text: "初始", value: "init"}, {text: "审批中", value: "Auditing"}, {text: "已审批", value: "Audited"}]],
        [GlobalVariable.V_BPMN_COUNTERSIGN_CONDITION_TYPE, [{text: "无", value: "None"}, {text: "数量", value: "Number"}, {text: "比例", value: "Proportion"}, {text: "自定义", value: "Custom"}]]  
    ]);

    public static registerVariable(key: string, obj: any): void {
        GlobalVariable.mapVariables.set(key, obj);
    }

    public static getVarialble(key: string): any {
        if (!key) return null;
        if (GlobalVariable.isVarialble(key)) {
            var variable = GlobalVariable.mapVariables.get(key);
            if (variable instanceof Function) {
                return variable();
            } else {
                return variable;
            }
        }
        return key;
    }

    public static isVarialble(str: string): boolean {
        var s = str.trim();
        return s.startsWith("{") && s.endsWith("}");
    }

    public static isFormula(str: string | undefined): boolean {
        if (!str) return false;
        
        var s = str.trim();
        return  s.startsWith("=");
    }

    public static getFormula(str: string) {
        if (GlobalVariable.isFormula(str)) {
            return str.substring(1);
        }
        return str;
    }

    public static hasVarialble(str: string) {
        return GlobalVariable.mapVariables.has(str);
    }

    

   /* public static getMode(): EDesignMode {
        return window.DesignMode ? window.DesignMode : EDesignMode.Product;
    }

    public static isProductMode(): boolean {
        return GlobalVariable.getMode() == EDesignMode.Product;
    }*/
}