import StringBuilder from "../../util/StringBuilder";
import StringUtil from "../../util/StringUtil";
import XmlEntity from "../XmlEntity";
import XmlParser from "../XmlParser";

export default class XmlUtil {

    static getTagName(xmlFragment: string): string {
        try {
            let parser: XmlParser = new XmlParser();
            var lineEntity = new XmlEntity(true);
            parser.parse(xmlFragment, lineEntity);
            var tagNode = lineEntity.getTagRoot();
            return tagNode.getTagName();
        } catch (e) {
            return "";
        }
    }

    static removeReturnChars(strFragment: string): string {
        if (strFragment && typeof strFragment == "string") {
			strFragment = strFragment.replace(/[\r\n]/g,"");
		}
        return strFragment;
    }

    static escape(text: string): string {
        text = String(text);// 转一下字符串，其他类型没有replace方法
		return text.replace(/&amp;/g, '&')
				.replace(/&quot;/g, '"')
				.replace(/&lt;/g, '<')
				.replace(/&gt;/g, '>');
	}

	static unescape(text: string){
        text = String(text); // 转一下字符串，其他类型没有replace方法
		return text.replace(/&/g, '&amp;')
				.replace(/"/g, '&quot;')
				.replace(/</g, '&lt;')
				.replace(/>/g, '&gt;');
	}

    static indentLine4Html(level: number,  sb: StringBuilder) {
        for (let i = 0; i < level; i++) {
            sb.append(StringUtil.STR_INDENT_NBSP);
        }
    }

    static indentLine(level: number,  sb: StringBuilder) {
        for (let i = 0; i < level; i++) {
            sb.append(StringUtil.STR_INDENT_SPACE);
        }
    }

    static error(line: number, pos: number, msg: string): void {
        if (line > 0 && pos > 0) {
			throw new Error(`${msg} in line ${line}, pos ${pos}\n`);
        } else {
			throw new Error(msg);
        }
    }

    static throwError(msg: string) {
        throw new Error(msg);
    }

    static checkXml(xml: string): boolean {
        try {
            XmlEntity.parse(xml);
            return true;
        } catch(e) {
            return false;
        }
    }
}