export default class StringUtil {

    public static STR_INDENT_NBSP:string = "&nbsp;&nbsp;&nbsp;&nbsp;";

    public static STR_INDENT_SPACE:string = "    ";

    public static STR_HTML_SPACE:string = " ";

    public static STR_SPACE: string = " ";

    public static CONTENT_END: string = '$';

    public static isBlank(c: string): boolean {
		  return c == ' ' || c == '\t' || c== '\n' || c == '\r' || c.charCodeAt(0) == 65279;
  	}

    public static isBlankOrNull(str: string): boolean {
      return !str;
    }

    public static isContentEnd(char: string): boolean {
      return char == StringUtil.CONTENT_END;
    }

    public static isDigit(c: string): boolean {
      return c>='0' && c <='9';
    }

    public static isAlpha(c: string): boolean {
      return (c>='a' && c <='z') || (c>='A' && c <='Z');
    }

    public static split(s: string, sp: string): string[] {
      if (!s) return [];
      return s.split(sp);
    }
}