import IGElement from "./IGElement";

/**
 * 图形绘制引擎 Section
 *
 */
export default interface IGTable {

    line(x1:number,y1:number,x2:number,y2:number): IGTable;
    table(x:number,y:number,width:number,height:number,ele:HTMLElement):SVGForeignObjectElement
    clear():void;
    attr(params:{[attr:string]:string|number|boolean|any}):IGTable;
    getHtmlElement(): HTMLElement;
    path(pathSpec: string | (string | number)[][]): IGTable;
    section(varargs?:any): IGTable;
    mousedown(handler: (event: MouseEvent) => void, thisArg?: any): IGTable;
    mousemove(handler: (event: MouseEvent) => void, thisArg?: any): IGTable;
    mouseout(handler: (event: MouseEvent) => void, thisArg?: any): IGTable;
    mouseover(handler: (event: MouseEvent) => void, thisArg?: any): IGTable;
    mouseup(handler: (event: MouseEvent) => void, thisArg?: any): IGTable;
    remove(): IGTable;

}