import IGElement from "./IGElement";
/**
 * 图形绘制引擎 Section
 * 
 */
export default interface IGSection extends IGElement {

    circle(x:number,y:number,r:number): IGElement;
    ellipse(x:number,y:number,rx:number,ry:number): IGElement;
    image(src:string,x:number,y:number,width:number,height:number): IGElement;
    line(x1:number,y1:number,x2:number,y2:number): IGElement;
    path(pathSpec: string | (string | number)[][]): IGElement;
    polygon(varargs:any[]): IGElement;
    polyline(varargs:any[]): IGElement;
    rect(x:number,y:number,width:number,height:number,rx?:number,ry?:number): IGElement;
    text(x:number,y:number,text:string|number): IGElement;
    text(x:number,y:number,text:Array<string|number>): IGElement;
    symbol(vbx:number,vby:number,vbw:number,vbh:number): IGElement;

    section(varargs?:any): IGSection;

    clear():void;
}