import IStyleFactory from "./IStyleFactory";
import {CheckboxSkin, CollapseSkin, ExcelSkin, MenuSkin, PrintSkin, TableSkin, TabPaneSkin, TreeSkin} from "./Skins";

export default class BaseStyleFactory implements IStyleFactory {

    getIcon(): string {
        return "layui-icon";
    }

    getBpmWorkspace(): string[] {
        return ["djs-container"];
    }

    getToolBox(): string[] {
        return ["djs-palette"];
    }

    getToolboxSeparator(): string[] {
        return ["separator"];
    }

    getPropertyPanel(): string[] {
        return ["property-pane"];
    }

    getToolbar(): string[] {
        return ["bpm-toolbar"];
    }

    getList(): string[] {
        return ["component-list"];
    }

    getToolbarSeparator(): string[] {
        return ["vr"];
    }

    getTabPaneSkin(): TabPaneSkin {
        return {
            tab: "layui-tab",
            tab_title: "layui-tab-title",
            //tab_content: "layui-tab-content",
            tab_content: "",
            tab_item: "layui-tab-item",
            tab_nav_this: "layui-this",
            tab_close: "layui-tab-close"
        };
    }

    getMenuStyle(): MenuSkin {
        return {
            menu: 'cmd-change-menu__overlay',
            menu_header: 'cmd-change-menu__header',
            menu_title: 'cmd-change-menu__title',
            menu_body: 'cmd-change-menu__body',
            menu_group: 'cmd-change-menu__results',
            menu_item: 'cmd-change-menu__entry',
            menu_item_content: 'md-change-menu__entry-content',
            menu_item_caption: 'cmd-change-menu__name'
        };
    }

    getTableSkin(): TableSkin {
        return {
            table: 'layui-table',
            table_view: 'layui-table-view',
            table_box: 'layui-table-box',
            table_header: 'layui-table-header',
            table_cell: 'layui-table-cell',
            table_body: 'layui-table-body',
            table_main: 'layui-table-main',
            table_page: 'layui-table-page'
        }
    }

    getCheckboxSkin(): CheckboxSkin {
        return {
            checkbox: 'el-checkbox',
            checkbox_input: 'el-checkbox__input',
            checkbox_inner: 'el-checkbox__inner',
            checkbox_original: 'el-checkbox__original',
            checkbox_label: 'el-checkbox__label'
        };
    }

    getCollapseSkin(): CollapseSkin {
        return {
            collapse: 'yg_collapse',
            collapse_text: 'yg_collapse_text'
        };
    }

    getPrintSkin(): PrintSkin {
        return {
            print_board: 'print-board',
            print_paper: 'print_paper',
            print_page: 'print_page',
            print_grid: 'print-grid',
            print_section: 'print-section',
            print_row: 'print-row',
            print_cell: 'print-cell',
            print_v_ruler: 'v_ruler',
            print_h_ruler: 'h_ruler'
        };
    }

    getExcelSkin(): ExcelSkin {
        return {
            excel_board: 'excel-board',
            excel_paper: 'excel',
            excel_page: 'excel',
            excel_grid: 'excel-grid',
            excel_section: 'excel-section',
            excel_row: 'excel-row',
            excel_cell: 'excel-cell'
        };
    }

    getTreeSkin(): TreeSkin {
        return {
            tree: 'yg-tree',
            tree_item: 'yg-tree-item',
            tree_item_node: 'yg-tree-node'
        }
    }
}