import UserEvent from "../event/UserEvent";
import ArrayList from "../struct/ArrayList";
import IModelBindable from "./IModelBindable";

export default abstract class AbstractModel {

    private binds: ArrayList<IModelBindable<any>> = new ArrayList<IModelBindable<any>>();

    constructor() {
    }

    public bind(bindable: IModelBindable<any>): void {
        if (!this.binds.contain(bindable)) {
            this.binds.add(bindable);
        }
    }

    public unbind(bindable: IModelBindable<any>): void {
        this.binds.remove(bindable);
    }

    public unbindAll(): void {
        this.binds.clearAll();
    }

    public fireModelEvent(event: UserEvent): void {
        for (let bindable of this.binds.getList()) {
            bindable && bindable.fireEvent(event);
        }
    }
}