
import AbstractDomElement from "../../../../dom/AbstractDomElement";
import JTree from "../JTree";

import TreeItemModel from "../model/TreeItemModel";
import JTreeItem from "./JTreeItem";

/**
 * 树分组项
 * 
 * @author chenbinbin
 */
export default class JTreeItemGroup extends AbstractDomElement {

    private itemModel: TreeItemModel;

    private tree: JTree;

    constructor(itemModel: TreeItemModel, tree: JTree) {
        super();
        this.itemModel = itemModel;
        this.tree = tree;
    }

    protected createEl(tag:string): HTMLElement {
        return document.createElement("ul");
    }

    public loadChildren(model: TreeItemModel = this.itemModel, group: JTreeItemGroup = this): void {
        for (let item of model.getChildren()) {
            var child = new JTreeItem(item, this.tree);
            group.addChild(child);
            if (item.isExpand()) {
                this.loadChildren(item, child.ensureNodeGroup());
            }
        }
    }

    public unloadChildren(): void {
        for (let item of this.getModel().getChildren()) {
            item.unbindAll();
        }
        this.clearChildren();
    }

    public getModel(): TreeItemModel {
        return this.itemModel;
    }
}