import DivElement from "../../dom/element/DivElement";
import ArrayList from "../../struct/ArrayList";
import JComponent from "../JComponent";
import ToolFontItem from "./ToolFontItem";
import ToolSvgItem from "./ToolSvgItem";

export default class SideToolbox extends JComponent<DivElement> {

    private preHeight: number = 0;

    private items: ArrayList<JComponent<DivElement>> = new ArrayList();

    constructor() {
        super(new DivElement());
        this.addClass("bpm-toolbox");
        this.addClassArray(this.styleFactory.getToolBox());
    }

    public addFontItem(key: string, option: {cls: string[]}): ToolFontItem {
        var item = new ToolFontItem(key, option);
        this.preHeight += item.getHeightValue();
        this.items.add(item);
        this.getDomElement().addChild(item.getDomElement());
        return item;
    }

    public addSvgItem(key: string, svg: string, option: {cls: string[]}): ToolFontItem {
        var item = new ToolSvgItem(key, svg, option);
        this.preHeight += item.getHeightValue();
        this.items.add(item);
        this.getDomElement().addChild(item.getDomElement());
        return item;
    }

    public addSeparator(): void {
        this.preHeight += 6;
        var sp = new DivElement();
        sp.addClassArray(this.styleFactory.getToolboxSeparator());
        this.getDomElement().addChild(sp);
    }

    public getPreHeight(): number {
        return this.preHeight;
    }

    public getPos(item: ToolFontItem): number {
        var pos = 0;
        for (let t of this.items.getList()) {
            if (item == t) {
                break;
            }
            pos += t.getHeightValue(); 
        }
        return pos;
    }
}
