/* package com.vico.vicosoft.client.base.ui.component.grid.column;

import com.vico.vicosoft.client.base.ui.component.grid.config.GridColumnConfig;

import java.util.ArrayList;
import java.util.List;

public class GridColumnBuilder {
	
	private int maxRow = 0;
	
	private int maxCol = 0;
	
	private GridColumn root = null;
	
	private List<GridColumn> leafColumns = new ArrayList<>();
	
    public List<GridColumn> build(List<GridColumnConfig> columnConfigs) {
        GridColumn childColumn = null;
        root = new GridColumn();
        for (GridColumnConfig columnConfig : columnConfigs) {
            childColumn = root.addChildColumn();
            initColumnByConfig(childColumn, columnConfig);
        }
        autoSetColumns(root.getChildColumns(), 0, 0);
        return root.getChildColumns();
    }
    
    public List<GridColumn> getLeafColumns() {
    	return root.getLeafColumns();
    }

    public GridColumn getRoot() {
        return this.root;
    }
    
    public int getRowCount() {
        // root这一层不算
    	return this.root.getDeep() - 1;
    }

    private void initColumnByConfig(GridColumn gridColumn, GridColumnConfig columnConfig) {
        gridColumn.setKey(columnConfig.getKey());
        gridColumn.setCaption(columnConfig.getCaption());
        if (!columnConfig.hasChildren()) {
            gridColumn.widthProperty().bindBidirectional(columnConfig.widthProperty());
        }
        addChildColumns(gridColumn, columnConfig);
    }
    
    private void addChildColumns(GridColumn gridColumn, GridColumnConfig columnConfig) {
        GridColumn childColumn = null;
        if (columnConfig.hasChildren()) {
            for (GridColumnConfig childColumnConfig : columnConfig.getChildColumns()) {
                childColumn = gridColumn.addChildColumn();
                initColumnByConfig(childColumn, childColumnConfig);
            }
        }
    }
    
    private void autoSetColumns(List<GridColumn> columns, int startRow, int startCol) {
        GridColumn preColumn = null;
    	for (GridColumn column: columns) {
            int col = preColumn == null ? startCol : (preColumn.getCol() + preColumn.getColSpan());
            prepareColumnPosition(column, startRow, col);
            preColumn = column;
        }
    }

    // 将所有的叶子节点归集
    private void prepareColumnPosition(GridColumn column, int row, int col) {
        this.maxRow = Math.max(row, maxRow);
        this.maxCol = Math.max(col, maxCol);
        column.setCol(col);
        column.setRow(row);
        if (column.hasChildColumn()) {
        	column.setRowSpan(1);
        	column.setColSpan(column.getLeafCount());
            autoSetColumns(column.getChildColumns(), row + 1, col);
        } else {
        	column.setRowSpan(getRowCount() - column.getRow());
        	column.setColSpan(1);
        }
    }
}
 */