import AbstractDomElement from "../../../dom/AbstractDomElement";
import ColumnAreaConfig from "../base/column/ColumnAreaConfig";
import ColumnConfig from "../base/column/ColumnConfig";
import JTableHeadCell from "../base/head/JTableHeadCell";
import JTable from "../base/JTable";

export default class JTableHeadArea extends AbstractDomElement {

    private headTable: JTable;

    private columnAreaConfig: ColumnAreaConfig;

    constructor(columnAreaConfig: ColumnAreaConfig) {
        super();
        this.columnAreaConfig = columnAreaConfig;
        this.headTable = new JTable("");
        this.addChild(this.headTable.getDomElement());
        this.initSkin();
    }

    private initSkin() {
        var skin = this.styleFactory.getTableSkin();
        this.addClass(skin.table_header);
    }

    addColumn(columnConfig: ColumnConfig): void {
        this.headTable.addCol(columnConfig.getWidth());
    }

    getHeight(): number {
        return 30;
    }

    display(parent: AbstractDomElement): void {
        this.headTable.clearHeadRow();
        if (!this.columnAreaConfig.isEmpty()) {
            var row = this.headTable.addHeadRow();
            var columns = this.columnAreaConfig.getColumns();
            for (let column of columns) {
                var cell = new JTableHeadCell(column.getCaption());
                //this.headTable.addCol(column.getWidth());
                //cell.setElementWidth(column.getWidth());
                row.addCell(cell);
            }
        }
    }
}
