
import SizeInfo from "../../../struct/SizeInfo";
import AbstractDomElement from "../../../dom/AbstractDomElement";
import { ESizeType } from "../../../enum/Enums";
import GlobalStyle from "../../../style/GlobalStyle";
import IStyleFactory from "../../../style/IStyleFactory";
import StyleFactoryMananger from "../../../style/StyleFactoryMananger";
import JTableBodyRow from "../base/body/JTableBodyRow";
import ColumnAreaConfig from "../base/column/ColumnAreaConfig";
import ColumnConfig from "../base/column/ColumnConfig";
import JTableBodyArea from "./JTableBodyArea";
import JTableHeaderArea from "./JTableHeadArea";

export default class JTableArea extends AbstractDomElement {

    protected styleFactory: IStyleFactory =  StyleFactoryMananger.getInstance().getStyleFactory();

    private columnAreaConfig: ColumnAreaConfig;

    private headerArea: JTableHeaderArea;

    private bodyArea: JTableBodyArea;

    private height: number = -1;
    
    constructor() {
        super();
        this.columnAreaConfig = new ColumnAreaConfig();
        this.headerArea = new JTableHeaderArea(this.columnAreaConfig);
        this.bodyArea = new JTableBodyArea(this.columnAreaConfig);
        this.addChild(this.headerArea);
        this.addChild(this.bodyArea);
        this.initSkin();
    }

    private initSkin() {
        var skin = this.styleFactory.getTableSkin();
        this.addClass(skin.table_box);
    }

    addColumn(key: string, caption?: string): ColumnConfig {
        var columnConfig = this.columnAreaConfig.addColumn(key, caption);
        this.headerArea.addColumn(columnConfig);
        this.bodyArea.addColumn(columnConfig);
        return columnConfig;
    }

    addRow(): JTableBodyRow {
        return this.bodyArea.addRow();
    }

    setBodyCellValue(row: number, col: number, value: any): void {
        this.bodyArea.setBodyCellValue(row, col, value);
    }

    setHeight(height: number): void {
        this.height = height;
    }


    display(parent: AbstractDomElement): void {
        if (this.height > this.headerArea.getHeight()) {
            this.bodyArea.setStyleHeight(SizeInfo.valueOf(this.height - this.headerArea.getHeight(), ESizeType.px));
        }
        this.headerArea.display(this);
        this.bodyArea.display(this);

        if (this.bodyArea.hasVScroll()) {
            this.headerArea.addClass(GlobalStyle.SCROLL_MARGIN);
        }
    }
}