import YigoGrid from "../../../yiui/design/control/YigoGrid";
import AbstractDomElement from "../../dom/AbstractDomElement";
import DomUtil from "../../dom/DomUtil";
import IOperatioExecutor from "../../operation/IOperatioExecutor";
import OperationDispatcher from "../../operation/OperationDispatcher";
import AbstractControl from "../control/AbstractControl";
import BooleanControl from "../control/BooleanControl";
import ButtonEditor from "../control/ButtonEditor";
import TempButtonEditor from "../control/TempButtonEditor";
import Checkbox from "../control/Checkbox";
import ColorEditor from "../control/ColorEditor";
import Combobox from "../control/Combobox";
import Label from "../control/Label";
import NumberEditor from "../control/NumberEditor";
import TextEditor from "../control/TextEditor";
import { EComponentType } from "../EComponentType";
import DataMapTextEditor from "../control/DataMapTextEditor";
import Hyperlink from "../control/Hyperlink";

export default class ControlFactory {

    constructor() {
    }

    private static getYigoGridEl(key: string, operationDispatcher: OperationDispatcher): any {
        var grid = ControlFactory.getYigoComponent(key, operationDispatcher);
        if (grid) {
            var el = DomUtil.findParentElByClassName(grid.getEl().getElm(), 'ui-ygrid');
            return el;
        } else {
            return null;
        }
    }

    static getYigoComponent(key: string, operationDispatcher: OperationDispatcher): YIUI.Control.Grid | null {
        if (operationDispatcher) {
            return operationDispatcher.getComponent(key);
        } else {
            return null;
        }
    }

    static async getPropertyGrid(key: string, operationDispatcher: OperationDispatcher): Promise<YigoGrid | undefined> {
        var el = ControlFactory.getYigoGridEl(key, operationDispatcher);
        if (el) {
            var gridComponent = ControlFactory.getYigoComponent(key, operationDispatcher);
            var grid = new YigoGrid(gridComponent, el, operationDispatcher);
            await grid.init();
            return grid;
        }
        return undefined;
    }

    public static createControl(control: string, config?: any, operationDispatcher?: IOperatioExecutor): AbstractControl<any> {
        var uiControl: AbstractControl<any> = new TextEditor();
        switch (control) {
            case EComponentType.Label:
                uiControl = new Label("");
                break;
             case EComponentType.Hyperlink:
                uiControl = new Hyperlink();
                break;
            case EComponentType.TextEditor:
                uiControl = new TextEditor();
                break;
            case EComponentType.Checkbox:
                uiControl = new Checkbox('');
                break;
            case EComponentType.Combobox:
                uiControl = new Combobox();
                break;
            case EComponentType.NumberEditor:
                uiControl = new NumberEditor();
                break;
            case EComponentType.ButtonEditor:
                uiControl = new ButtonEditor();
                break;
            case EComponentType.TempButtonEditor:
                uiControl = new TempButtonEditor();
                break;
            case EComponentType.ColorEditor:
                uiControl = new ColorEditor();
                break;
            case EComponentType.YigoControl:
            case EComponentType.YigoDict:
            case EComponentType.YigoCodeDict:
                if (operationDispatcher) {
                    uiControl = operationDispatcher.createYigoControl(config.key, control, config.component);
                }
                break;
            case EComponentType.DataMapTextEditor:
                uiControl = new DataMapTextEditor();
                break;
        }
        config && uiControl.setKey(config.key);
        return uiControl;
    }
}