import InputElement from "../../dom/element/InputElement";
import AbstractControl from "./AbstractControl";

export default class TextEditor extends AbstractControl<InputElement> {

    constructor() {
        super(new InputElement());
        this.setStyle('border', '0px');
        this.setStyle('outline', 'none');
    }

    protected createEl(): HTMLElement {
        return document.createElement('input');
    }

    setPlaceholder(placeholder: string): void {
        this.getDomElement().setPlaceholder(placeholder);
    }

    setValue(value: any): void {
        super.setValue(value);
        var inputEl: HTMLInputElement = <HTMLInputElement>this.getEl();
        inputEl.value = value;
    }

    getValue(): any {
        var inputEl: HTMLInputElement = <HTMLInputElement>this.getEl();
        return inputEl.value;
    }

    getShowText(): string {
        return this.getValue();
    }

    setShowText(showText: string): void {
    }

    setEditable(editable: boolean): void {
        var inputEl: HTMLInputElement = <HTMLInputElement>this.getEl();
        if (editable) {
            inputEl.removeAttribute('readonly');
        } else {
            inputEl.setAttribute('readonly', "true");
        }
    }

    caretLast(): void {
        var el: any = this.getEl();
        var pos = this.getShowText() ? this.getShowText().length : 0;
        if (el.setSelectionRange) {
            el.focus();
            el.setSelectionRange(pos, pos);
        }
    }

    setAttr(name: string, value: string): void {
        this.getEl().setAttribute(name, value);
    }
}