import AbstractDomElement from "../../dom/AbstractDomElement";
import DomUtil from "../../dom/DomUtil";
import SpanElement from "../../dom/element/SpanElement";
import SizeInfo from "../../struct/SizeInfo";
import AbstractControl from "./AbstractControl";
import DownArrow from "./DownArrow";
import TextEditor from "./TextEditor";

export default class ExcelColorEditor extends AbstractControl<SpanElement> {

    private textEditor: TextEditor;

    private button: DownArrow;
    //private button: Button;
    private colorContainer: ColorContainer;

    constructor() {
        super(new SpanElement());
        this.textEditor = new TextEditor();
        this.button = new DownArrow();
        //this.button = new Button("...");
        this.getDomElement().addChild(this.textEditor.getDomElement());
        this.getDomElement().addChild(this.button.getDomElement());
        //this.button.setStyle('margin', '0px 0px 0px -24px');
        this.colorContainer = new ColorContainer();
        var self = this;
        this.button.addEventListener("click", function (event: any) {
            event = event || window.event;
            if (self.getDomElement().getChildCount() > 2) {
                self.getDomElement().removeChild(self.colorContainer);
            } else {
                self.getDomElement().addChild(self.colorContainer);
                self.colorContainer.getEl().focus();
                self.colorContainer.setValue(self.getValue());
            }
            //var {offsetBodyLeft, offsetBodyTop} = DomUtil.offsetBodyPosition(self.button.getEl());
            // console.log(offsetBodyLeft + ":" + offsetBodyTop);
        }, true);

        this.colorContainer.addEventListener("click", (e: any) => {
            var el = e.target;
            if (el.classList.contains('property-color-item')) {
                var item: ColorItem = <ColorItem>self.colorContainer.findElement(el);
                self.setValue(item.getColor());
                self.getDomElement().removeChild(self.colorContainer);
                this.fnOnValueChange && this.fnOnValueChange(this);
            }
        }, true);
        this.colorContainer.addEventListener("blur", (e: any) => {
            var el = e.target;
            setTimeout(function (){
                self.getDomElement().removeChild(self.colorContainer);
            },1)
        }, true);
    }

    setValue(value: any): void {
        super.setValue(value);
        let values = value.split(":")
        this.textEditor.setValue(values[0]);
        if (values.length>1){
            this.textEditor.setStyle('background-color', values[1]);
        }else {
            this.textEditor.setStyle('background-color', values[0]);
        }
    }
    setValueAndStyle(value: any,style:any): void {
        super.setValue(value);
        this.textEditor.setValue(value);
        this.textEditor.setStyle('background-color', style);
    }


    getValue(): any {
        return this.textEditor.getValue();
    }

    setHeight(height: SizeInfo) {
        this.textEditor.setHeight(height);
        this.button.setHeight(SizeInfo.valueOfPX(height.getValue() - 2));
    }

    setWidth(width: SizeInfo) {
        var w = width.getValue();
        this.textEditor.setWidth(SizeInfo.valueOfPX(w - 27));
        this.button.setWidth(SizeInfo.valueOfPX(27));
    }

    lostFocus() {
        this.getDomElement().removeChild(this.colorContainer);
    }
}

class ColorItem extends AbstractDomElement {
    private color: string;

    constructor(color: string) {
        super();
        let values = color.split(":")
        this.color =color;
        this.addClass('property-color-item');
        if (values.length>1){
            this.setStyle('background', values[1]);
        }else {
            this.setStyle('background', values[0]);
        }
        this.setStyle('width', '12px');
        this.setStyle('height', '12px');
        this.setStyle('margin', '1px');
        this.setStyle('cursor', 'pointer');
        this.setStyle('border-width', '1px');
    }

    public getColor(): string {
        return this.color;
    }
}

class ColorContainer extends AbstractDomElement {
    private width: number = 135;
    private color_array = [
        "BLACK", "WHITE", "RED", "BRIGHT_GREEN:rgb(144,238,144)", "BLUE", "YELLOW", "PINK", "TURQUOISE",
        "DARK_RED:rgb(139,0,0)", "GREEN:rgb(0,128,0)", "DARK_BLUE:rgb(0,0,139)", "DARK_YELLOW:rgb(250,250,210)", "VIOLET", "TEAL", "GREY_25_PERCENT:rgb(112,128,144)", "GREY_50_PERCENT:rgb(211,211,211)",
        "CORNFLOWER_BLUE:rgb(100,149,237)", "MAROON", "LEMON_CHIFFON:rgb(255,250,205)", "ORCHID", "CORAL", "ROYAL_BLUE:rgb(65,105,225)", "LIGHT_CORNFLOWER_BLUE:rgb(176,196,222)", "SKY_BLUE:rgb(135,206,235)",
        "LIGHT_TURQUOISE:rgb(175,238,238)", "LIGHT_GREEN:rgb(144,238,144)", "LIGHT_YELLOW:rgb(255,255,224)",  "ROSE:rgb(255,105,180)", "LAVENDER", "TAN", "LIGHT_BLUE:rgb(173,216,230)", "AQUA",
        "LIME", "GOLD", "LIGHT_ORANGE:rgb(255,69,0)", "ORANGE", "BLUE_GREY:rgb(138,43,226)", "GREY_40_PERCENT:rgb(119,136,153)", "DARK_TEAL:rgb(47,79,79)", "SEA_GREEN:rgb(46,139,87)",
        "DARK_GREEN:rgb(0,100,0)", "OLIVE_GREEN:rgb(85,107,47)", "BROWN", "PLUM", "INDIGO", "GREY_80_PERCENT:rgb(60,90,90)",
    ];

    constructor() {
        super();
        this.setStyle('position', 'absolute');
        this.setStyle('z-index', '66666666');
        this.setStyle('display', 'flex');
        this.setStyle('width', this.width + 'px');
        this.setStyle('height', '160px');
        this.setStyle('margin', '5px');
        this.setStyle('flex-direction', 'row');
        this.setStyle('flex-wrap', 'wrap');
        this.setStyle('justify-content', 'center');
        this.setStyle('align-items', 'center');
        this.setStyle('background-color', '#cec7c7');
        this.setAttr("tabindex","0")
        // 遍历数组，添加pick按钮至容器
        for (let color of this.color_array) {
            var colorItem = new ColorItem(color);
            this.addChild(colorItem);
        }
    }

    setValue(color: string): void {
        for (let child of this.getChildren()) {
            var item = <ColorItem>child;
            item.removeClass('property-color-item-focus');
            if (color == item.getColor()) {
                item.addClass('property-color-item-focus');
            }
        }
    }

    setLocation(left: number, top: number): void {
        this.setStyle('left', left + 'px');
        this.setStyle('top', top + 'px');
    }

    public getWidth(): number {
        return this.width;
    }
}