
import { ESizeType } from "../../../../enum/Enums";
import SizeInfo from "../../../../struct/SizeInfo";
import JComponent from "../../../JComponent";
import Panel from "../JPanel";
import AbstractLayout from "./AbstractLayout";
import SplitLayoutItem from "./item/SplitLayoutItem";

/**
 * splitlayout的尺寸之支持固定值
 */
export default class SplitLayout extends AbstractLayout<SplitLayoutItem> {

    private isVertical = true;

    constructor(isVertical: boolean, sizes: SizeInfo[]) {
        super();
        this.isVertical = isVertical;
        this.init(sizes);
    }

    init(sizes: SizeInfo[]) {
        for (let size of sizes) {
            var item = this.addLayoutItem(null);
            if (this.isVertical) {item.setHeight(size)} else {item.setWidth(size)}
        }
    }

    public layout(container: Panel<SplitLayoutItem, SplitLayout>): void {
        container.setStyle("display", "flex");
        container.setStyle("flex-flow", this.isVertical ? "column" : "row");
        this.vGap && container.setStyle("row-gap", this.vGap.toString());
        this.hGap && container.setStyle("column-gap", this.hGap.toString());
        this.setSize(container, this.isVertical ? container.getHeight() : container.getWidth());
        this.layoutChildren(container, container.getWidth().getValue(), container.getHeight().getValue());
    }

    private layoutChildren(container: Panel<SplitLayoutItem, SplitLayout>, width: number, height: number): void {
        var totalFixSize = this.getFixSize();
        var totalSize = this.isVertical ? height : width;
        var remainSize = totalSize - totalFixSize;
        for (let item of this.getLayoutItems()) {
            var node = item.getNode();
            var size = this.isVertical ? item.getHeight() : item.getWidth();
            if (SizeInfo.isPercentSize(size)) {
                var value = size.getValue() * remainSize / 100;
                this.setSize(node, SizeInfo.valueOf(value, ESizeType.px));
            } else {
                this.setSize(node, size);
            }
            node && node.display();
        }
    }

    private setSize(node: JComponent<any> | null, size: SizeInfo): void {
        if (node == null) return;
        if (this.isVertical) {
            node.setHeight(size);
        } else {
            node.setWidth(size);
        }
    }

    private getFixSize(): number {
        var totalFixSize = 0;
        var vG = this.vGap ? this.vGap.getValue() : 0;
        var hG = this.hGap ? this.hGap.getValue() : 0;
        var gap = this.isVertical ? vG : hG;
        for (let item of this.getLayoutItems()) {
            var size = this.isVertical ? item.getHeight() : item.getWidth();
            if (SizeInfo.isFixSize(size)) {
                totalFixSize += size.getValue();
            }
            totalFixSize += gap;
        }
        return totalFixSize;
    }

    protected createLayoutItem(): SplitLayoutItem {
        return new SplitLayoutItem();
    }
}