
import SizeInfo from "../../../../struct/SizeInfo";
import JComponent from "../../../JComponent";
import Component from "../../../JComponent";
import Panel from "../JPanel";
import AbstractLayout from "./AbstractLayout";
import GridLayoutItem from "./item/GridLayoutItem";

export default class H5GridLayout extends AbstractLayout<GridLayoutItem> {
    
    protected layoutRows: SizeInfo[];

    protected layoutColumns: SizeInfo[];

    constructor() {
        super();
        this.layoutRows = [];
        this.layoutColumns = [];
    }

    public setRowSize(index: number, size: SizeInfo) {
        this.layoutRows[index] = size;
    }

    public addRow(rowSize: SizeInfo): void {
        this.layoutRows.push(rowSize);
    }

    public setColumnSize(index: number, size: SizeInfo) {
        this.layoutColumns[index] = size;
    }

    public addColumn(columnSize: SizeInfo): void {
        this.layoutColumns.push(columnSize);
    }

    layout(container: Panel<GridLayoutItem, H5GridLayout>): void {
        container.setStyle("display", "grid");
        container.setStyle('width', container.getWidth().toString());
        container.setStyle('height', container.getHeight().toString());
        this.vGap && container.setStyle("row-gap", this.vGap.toString());
        this.hGap && container.setStyle("column-gap", this.hGap.toString());
        container.setStyle("grid-template-columns", this.getGridTemplateColumnsString());
        container.setStyle("grid-template-rows", this.getGridTemplateRowsString());

        let child: JComponent<any> | null = null;
        for (let layoutItem of this.layoutItems.getList()) {
            child = layoutItem.getNode();
            if (child != null) {
                var style = this.getGridAreaString(layoutItem);
                child.setStyle("grid-area", style);
                child.display();
            }
        }
    }

    protected createLayoutItem(): GridLayoutItem {
        return new GridLayoutItem();
    }
    
    private getGridAreaString(item: GridLayoutItem): string {
        var startX = item.getX();
        var endX = item.getX() + item.getXSpan() - 1;
        var startY = item.getY();
        var endY = item.getY() + item.getYSpan() - 1;
        
        return startY + "/ " + startX + "/ " + endY + "/ " + endX;
    }

    private getGridTemplateColumnsString(): string {
        var str: string = "";
        for (let layoutColumn of this.layoutColumns) {
            str += " " + layoutColumn.toString();
        }
        return str;
    }

    private getGridTemplateRowsString(): string {
        var str =  "";
        for (let layoutRow of this.layoutRows) {
            str += " " + layoutRow.toString();
        }
        return str;
    }
}