/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.workflow.sync;

import com.bokesoft.erp.webplugin.service.cache.IVersionCacheChangeListener;
import com.bokesoft.erp.webplugin.service.start.DBMetaBPMLoader;
import com.bokesoft.erp.webplugin.service.workflow.util.DBWorkflowUtil;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.dict.Item;

public class DBWorkflowChangeListener
implements IVersionCacheChangeListener {
    @Override
    public void fireAdd(String soid, DefaultContext context) {
        this.fireUpdate(soid, context);
    }

    @Override
    public void fireDelete(String soid, DefaultContext context) {
    }

    @Override
    public void fireUpdate(String soid, DefaultContext context) {
        try {
            IMetaFactory metaFactory = context.getVE().getMetaFactory();
            long workflowID = TypeConvertor.toLong((Object)soid);
            IDictCacheProxy dictCache = context.getDictCache();
            Item workflowItem = dictCache.getItem("BPMN_WorkflowConfig", workflowID);
            if (workflowItem == null) {
                LogSvr.getInstance().info("WorkflowID " + workflowID + " is not exist.");
                return;
            }
            String workflowKey = TypeConvertor.toString((Object)workflowItem.getValue("WorkflowKey"));
            String name = TypeConvertor.toString((Object)workflowItem.getValue("Name"));
            int version = TypeConvertor.toInteger((Object)workflowItem.getValue("Version"));
            int enable = TypeConvertor.toInteger((Object)workflowItem.getValue("Enable"));
            int nodeType = TypeConvertor.toInteger((Object)workflowItem.getValue("NodeType"));
            DBMetaBPMLoader loader = new DBMetaBPMLoader();
            if (enable == 1 && nodeType != 1) {
                loader.loadDeployInfo(workflowKey, version, metaFactory);
                String xml = DBWorkflowUtil.queryWorkflowXml(workflowID, context);
                loader.loadDBProfile(workflowKey, name, version, xml, metaFactory);
            } else {
                loader.removeLoadWorkflow(workflowKey, version, metaFactory);
            }
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }
}

